package com.gccloud.starter.common.module.notice.vo;

import com.gccloud.starter.common.module.file.vo.AttachmentFile;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 公告
 *
 * @author renxx
 * @data 2021/9/8 10:05
 */
@Data
public class SysNoticeVO implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(notes = "id")
    private String id;
    @ApiModelProperty(notes = "公告类型")
    private String type;
    @ApiModelProperty(notes = "公告标题")
    private String title;
    @ApiModelProperty(notes = "公告摘要")
    private String digest;
    @ApiModelProperty(notes = "公告内容")
    private String content;
    @ApiModelProperty(notes = "0：默认;1：置顶")
    private Integer stickTop;
    @ApiModelProperty(notes = "公告状态,0在线，1草稿，2下线")
    private Integer status;
    @ApiModelProperty(notes = "发布时间")
    private Date startDate;
    @ApiModelProperty(notes = "失效时间")
    private Date endDate;
    @ApiModelProperty(notes = "是否开启回复，0")
    private Integer replyEnable;
    @ApiModelProperty(notes = "回复次数")
    private Integer replyNum;
    @ApiModelProperty(notes = "阅读次数")
    private Integer readNum;
    @ApiModelProperty(notes = "发布人")
    private String publisher;
    @ApiModelProperty(notes = "附件")
    private List<AttachmentFile> attachment;
}
