package com.gccloud.starter.common.module.org.dto;

import com.baomidou.mybatisplus.annotation.TableId;
import com.gccloud.starter.extend.field.dto.SysOrgDTOExtend;
import com.gccloud.starter.common.validator.group.Insert;
import com.gccloud.starter.common.validator.group.Update;
import com.gccloud.starter.common.validator.module.org.Code;
import com.gccloud.starter.common.validator.module.org.Contact;
import com.gccloud.starter.common.validator.module.org.Email;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author liuchengbiao
 * @date 2020-06-28 19:50
 */
@Data
@ApiModel
public class SysOrgDTO extends SysOrgDTOExtend implements Serializable {

    private static final long serialVersionUID = 1L;
    /**
     * id 主键
     */
    @TableId
    @ApiModelProperty(notes = "主键")
    @NotBlank(message = "ID不能为空", groups = {Update.class})
    private String id;

    @NotBlank(message = "机构名称不能为空", groups = {Insert.class, Update.class})
    @ApiModelProperty(notes = "机构名称")
    private String name;

    @ApiModelProperty(notes = "机构全名")
    private String fullName;

    @NotBlank(message = "机构编码不能为空", groups = {Insert.class, Update.class})
    @Code(message = "{gc.starter.validator.org.code.message}", groups = {Insert.class, Update.class})
    @ApiModelProperty(notes = "机构编码")
    private String code;

    @ApiModelProperty(notes = "机构类型(如：市级公司、省级公司、部门等)")
    private String type;

    @ApiModelProperty(notes = "父机构ID")
    private String parentId;

    @ApiModelProperty(notes = "排序")
    private Integer orderNum;

    @ApiModelProperty(notes = "负责人")
    private String principal;

    @Contact(message = "{gc.starter.validator.org.contact.message}", groups = {Insert.class, Update.class})
    @ApiModelProperty(notes = "联系方式")
    private String contact;

    @ApiModelProperty(notes = "联系地址")
    private String address;

    @ApiModelProperty(notes = "邮政编码")
    private String zipCode;

    @Email(message = "{gc.starter.validator.org.email.message}", groups = {Insert.class, Update.class})
    @ApiModelProperty(notes = "电子邮箱")
    private String email;

    @ApiModelProperty(notes = "备注")
    private String remark;
}
