package com.gccloud.starter.common.module.org.vo;

import com.gccloud.starter.common.vo.TreeVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 给机构树使用
 */
@ApiModel
@Data
public class SysOrgTreeVO implements TreeVo<SysOrgTreeVO>, Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * id 主键
     */
    @ApiModelProperty(notes = "主键")
    private String id;

    @ApiModelProperty(notes = "机构名称")
    private String name;

    @ApiModelProperty(notes = "父机构名称")
    private String parentName;

    @ApiModelProperty(notes = "父机构ID")
    private String parentId;

    @ApiModelProperty(notes = "是否有子节点")
    private Boolean isParent;

    @ApiModelProperty(notes = "子机构")
    public List<SysOrgTreeVO> children;

    @Override
    public boolean equals(Object obj) {
        if(!(obj instanceof SysOrgTreeVO)) {
            return false;
        }
        SysOrgTreeVO treeVO = (SysOrgTreeVO) obj;
        if (this == treeVO) {
            return true;
        }
        return treeVO.id.equals(this.id);
    }

    @Override
    public int hashCode() {
        return id.hashCode();
    }
}
