package com.gccloud.starter.common.module.org.vo;

import com.baomidou.mybatisplus.annotation.TableId;
import com.gccloud.starter.extend.field.vo.SysOrgVOExtend;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @Author tang.jiawen
 * @Date 2020/6/16
 * @Version 1.0.0
 */
@ApiModel
@Data
public class SysOrgVO extends SysOrgVOExtend implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * id 主键
     */
    @TableId
    @ApiModelProperty(notes = "主键")
    private String id;

    @ApiModelProperty(notes = "机构名称")
    private String name;

    @ApiModelProperty(notes = "机构全名")
    private String fullName;

    @ApiModelProperty(notes = "机构编码")
    private String code;

    @ApiModelProperty(notes = "机构类型(如：市级公司、省级公司、部门等)")
    private String type;

    @ApiModelProperty(notes = "父机构ID")
    private String parentId;

    @ApiModelProperty(notes = "父机构名称")
    private String parentName;
    /**
     * 父机构ID集合，多个之间使用逗号隔开
     */
    @ApiModelProperty(notes = "父机构ID集合，多个之间使用逗号隔开")
    private String ids;

    @ApiModelProperty(notes = "父机构名称集合，多个之间使用逗号隔开")
    private String names;

    @ApiModelProperty(notes = "父机构编码集合，多个之间使用逗号隔开")
    private String codes;

    @ApiModelProperty(notes = "是否有子节点")
    private Boolean hasChildren;

    @ApiModelProperty(notes = "排序")
    private Integer orderNum;

    @ApiModelProperty(notes = "负责人")
    private String principal;

    @ApiModelProperty(notes = "联系方式")
    private String contact;

    @ApiModelProperty(notes = "联系地址")
    private String address;

    @ApiModelProperty(notes = "邮政编码")
    private String zipCode;

    @ApiModelProperty(notes = "电子邮箱")
    private String email;

    @ApiModelProperty(notes = "备注")
    private String remark;
}
