package com.gccloud.starter.common.module.post.dto;

import com.gccloud.starter.common.constant.GlobalConst;
import com.gccloud.starter.extend.field.dto.SysPostDTOExtend;
import com.gccloud.starter.common.validator.group.Insert;
import com.gccloud.starter.common.validator.group.Update;
import com.gccloud.starter.common.validator.module.post.Code;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author 萌级小菜鸟
 * @Date 2021年10月20日18:43:00
 * @Version 2.0.0
 */
@Data
public class SysPostDTO extends SysPostDTOExtend implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(notes = "主键")
    @NotBlank(message = "ID不能为空", groups = {Update.class})
    private String id;
    @ApiModelProperty(notes = "岗位名称")
    @NotBlank(message = "岗位名称不能为空", groups = {Update.class, Insert.class})
    private String name;
    @ApiModelProperty(notes = "岗位编码")
    @Code(message = "{gc.starter.validator.post.code.message}", groups = {Insert.class, Update.class})
    @NotBlank(message = "岗位编码不能为空", groups = {Update.class, Insert.class})
    private String code;
    @ApiModelProperty(notes = "岗位类型")
    @NotBlank(message = "岗位类型不能为空", groups = {Update.class, Insert.class})
    private String type;
    @ApiModelProperty(notes = "备注")
    private String remark;
    @ApiModelProperty(notes = "排序")
    private Integer orderNum = 1000;
    @ApiModelProperty(notes = "0为禁用，1为有效")
    @NotNull(message = "岗位状态不能为空", groups = {Update.class, Insert.class})
    private Integer status = GlobalConst.Post.Status.NORMAL;
}