package com.gccloud.starter.common.module.register.dto;

import com.gccloud.starter.common.constant.GlobalConst;
import com.gccloud.starter.common.validator.annotation.UUID;
import com.gccloud.starter.common.validator.group.Captcha;
import com.gccloud.starter.common.validator.group.Insert;
import com.gccloud.starter.common.validator.group.Uuid;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 注册
 *
 * @author liuchengbiao
 * @date 2019/4/24
 */
@Data
@ApiModel
public class SysRegDTO implements Serializable {

    @NotBlank(message = "用户名不能为空", groups = {Insert.class})
    @ApiModelProperty(notes = "用户名")
    @Length(min = 1, max = 100, message = "用户名长度必须在1~100之间")
    private String username;


    @NotBlank(message = "密码不能为空", groups = {Insert.class})
    @Length(min = 1, max = 500, message = "密码长度必须在1~500之间")
    @ApiModelProperty(notes = "密码")
    private String password;

    @NotBlank(message = "验证码不能为空", groups = {Captcha.class})
    @ApiModelProperty(notes = "验证码")
    private String captcha;

    @UUID(groups = {Uuid.class})
    @ApiModelProperty(notes = "UUID")
    private String uuid;

    /**
     * 用户所属租户id
     */
    @ApiModelProperty(notes = "所属租户ID")
    private String tenantId;

    @ApiModelProperty(notes = "终端类型")
    private String terminal;

    public String getTerminal() {
        if (StringUtils.isBlank(terminal)) {
            return GlobalConst.Login.DefaultTerminal.PC;
        }
        return terminal;
    }
}
