package com.gccloud.starter.common.module.register.dto;

import com.gccloud.starter.common.constant.GlobalConst;
import com.gccloud.starter.common.validator.group.Insert;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 手机注册
 * @Author zhang.tianming
 * @Date 2021/10/26 16:12
 * @Version 1.0
 */
@Data
public class SysRegPhoneDTO implements Serializable {
    @NotBlank(message = "手机号不能为空", groups = {Insert.class})
    @ApiModelProperty(notes = "手机号")
    private String phone;
    @NotBlank(message = "验证码不能为空", groups = {Insert.class})
    @ApiModelProperty(notes = "验证码")
    private String captcha;
    @ApiModelProperty(notes = "终端类型")
    private String terminal;

    public String getTerminal() {
        if (StringUtils.isBlank(terminal)) {
            return GlobalConst.Login.DefaultTerminal.PC;
        }
        return terminal;
    }
}
