package com.gccloud.starter.common.module.role.dto;

import com.gccloud.starter.common.constant.GlobalConst;
import com.gccloud.starter.common.validator.group.Insert;
import com.gccloud.starter.common.validator.group.Update;
import com.gccloud.starter.common.validator.module.category.Code;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @Author tang.jiawen
 * @Date 2020/7/2
 * @Version 1.0.0
 */
@Data
public class SysRoleDTO implements Serializable {
    @ApiModelProperty(notes = "主键")
    @NotBlank(message = "ID不能为空", groups = {Update.class})
    private String id;
    @NotBlank(message = "字典编码不能为空", groups = {Insert.class,Update.class})
    @Code(message = "{gc.starter.validator.role.code.message}", groups = {Insert.class, Update.class})
    @ApiModelProperty(notes = "角色编码")
    private String code;
    @ApiModelProperty(notes = "角色名称")
    @NotBlank(message = "角色名不能为空", groups = {Insert.class, Update.class})
    private String name;
    /**
     * 参考 {@link GlobalConst.Role.Type}
     */
    @ApiModelProperty(notes = "角色类型")
    @NotBlank(message = "角色类型不能为空", groups = {Insert.class, Update.class})
    private String type;
    @ApiModelProperty(notes = "机构id，只有机构角色需要")
    private String orgId;
    @ApiModelProperty(notes = "权重")
    private Integer weight;
    @ApiModelProperty(notes = "备注")
    private String remark;
    @NotBlank(message = "模块编码不能为空", groups = {Insert.class, Update.class})
    @ApiModelProperty(notes = "模块编码")
    private String moduleCode;
}
