package com.gccloud.starter.common.module.role.vo;

import com.gccloud.starter.common.constant.GlobalConst;
import com.gccloud.starter.extend.field.vo.SysRoleVOExtend;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 角色
 *
 * @Author tang.jiawen
 * @Date 2020/7/11
 * @Version 1.0.0
 */
@Data
@ApiModel
public class SysRoleVO extends SysRoleVOExtend implements Serializable {
    @ApiModelProperty(notes = "主键")
    private String id;
    @ApiModelProperty(notes = "角色编码")
    private String code;
    @ApiModelProperty(notes = "角色名称")
    private String name;
    @ApiModelProperty(notes = "机构角色的所属机构名称")
    private String orgId;
    @ApiModelProperty(notes = "机构角色的所属机构名称")
    private String orgName;
    /**
     * 参考 {@link GlobalConst.Role.Type}
     */
    @ApiModelProperty(notes = "角色类型")
    private String type;
    @ApiModelProperty(notes = "角色排序")
    private Integer orderNum;
    @ApiModelProperty(notes = "权重(权重越大，权限越大)")
    private Integer weight;
    @ApiModelProperty(notes = "备注")
    private String remark;
    @ApiModelProperty(notes = "创建时间")
    private Date createDate;
    @ApiModelProperty(notes = "更新时间")
    private Date updateDate;
    @ApiModelProperty(notes = "模块名称")
    private String moduleName;
    @ApiModelProperty(notes = "模块编码")
    private String moduleCode;
}
