package com.gccloud.starter.common.module.user.dto;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.gccloud.starter.common.entity.ExtendObj;
import com.gccloud.starter.common.mybatis.typeHandler.ExtendObjJsonTypeHandler;
import com.gccloud.starter.extend.field.dto.SysUserDTOExtend;
import com.gccloud.starter.common.validator.group.Insert;
import com.gccloud.starter.common.validator.group.Update;
import com.gccloud.starter.common.validator.module.user.Email;
import com.gccloud.starter.common.validator.module.user.Phone;
import com.gccloud.starter.common.validator.module.user.Username;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;


/**
 * 用户信息
 *
 * @Author tang.jiawen
 * @Date 2020/6/22
 * @Version 1.0.0
 */
@Data
public class SysUserDTO extends SysUserDTOExtend implements Serializable {
    @ApiModelProperty(notes = "主键")
    @NotBlank(message = "ID不能为空", groups = {Update.class})
    private String id;
    @ApiModelProperty(notes = "密码")
    private String password;
    @ApiModelProperty(notes = "QQ")
    private String qq;
    @ApiModelProperty(notes = "微信")
    private String wx;
    @ApiModelProperty(notes = "办公电话")
    private String officeTel;
    @ApiModelProperty(notes = "权重(权重越大，排名越靠前)")
    private Integer weight;
    @ApiModelProperty(notes = "真实姓名")
    private String realName;
    @ApiModelProperty(notes = "身份证号")
    private String idCard;
    @ApiModelProperty(notes = "手机号")
    @Phone(message = "{gc.starter.validator.user.phone.message}", groups = {Insert.class, Update.class})
    private String phone;
    @ApiModelProperty(notes = "用户邮箱")
    @Email(message = "{gc.starter.validator.user.email.message}", groups = {Insert.class, Update.class})
    private String email;
    @ApiModelProperty(notes = "用户状态，1表示正常，0表示禁用")
    private Integer status;
    @ApiModelProperty(notes = "工号")
    private String jobNumber;
    @NotBlank(message = "用户名不能为空", groups = {Insert.class, Update.class})
    @ApiModelProperty(notes = "用户名")
    @Length(min = 1, max = 100, message = "用户名长度必须在1~100之间")
    @Username(message = "{gc.starter.validator.user.email.message}", groups = {Insert.class})
    private String username;
    @ApiModelProperty(notes = "昵称")
    private String nickname;
    @ApiModelProperty(notes = "头像存储路径")
    private String avatar;
    @ApiModelProperty(notes = "性别,0表示女性，1表示男性")
    private Integer gender;
    @ApiModelProperty(notes = "所属租户ID")
    private String tenantId;
    @TableField(fill = FieldFill.INSERT)
    @ApiModelProperty(notes = "创建用户ID")
    private String createBy;
    @ApiModelProperty(notes = "工作单位")
    private String company;
    @ApiModelProperty(notes = "公司id")
    private String companyId;
    @ApiModelProperty(notes = "工作职责")
    private String responsibility;
    @ApiModelProperty(notes = "地址")
    private String address;
    @ApiModelProperty(notes = "预留字段，建议存储json格式")
    @TableField(typeHandler = ExtendObjJsonTypeHandler.class)
    private ExtendObj extendObj;
    @ApiModelProperty(notes = "角色列表")
    private List<String> roleIdList;
    @ApiModelProperty(notes = "岗位ID列表")
    private List<String> postIdList;
    @ApiModelProperty(notes = "所属行政机构id")
    private String orgId;
    @ApiModelProperty(notes = "所属机构ID集合")
    private List<String> belongOrgIdList;
    @ApiModelProperty(notes = "管理机构ID集合")
    private List<String> manageOrgIdList;
}
