package com.gccloud.starter.common.module.user.dto;

import com.gccloud.starter.common.validator.module.user.Email;
import com.gccloud.starter.common.validator.module.user.Phone;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class SysUserInfoDTO implements Serializable {
    @ApiModelProperty(notes = "用户名")
    private String username;
    @ApiModelProperty(notes = "昵称")
    private String nickname;
    @ApiModelProperty(notes = "真实姓名")
    private String realName;
    @ApiModelProperty(notes = "工号")
    private String jobNumber;
    @ApiModelProperty(notes = "密码")
    private String password;
    @ApiModelProperty(notes = "身份证号")
    private String idCard;
    @ApiModelProperty(notes = "手机号")
    @Phone(message = "{gc.starter.validator.user.phone.message}")
    private String phone;
    @ApiModelProperty(notes = "办公电话")
    private String officeTel;
    @ApiModelProperty(notes = "QQ")
    private String qq;
    @ApiModelProperty(notes = "微信")
    private String wx;
    @ApiModelProperty(notes = "工作单位")
    private String company;
    @ApiModelProperty(notes = "工作职责")
    private String responsibility;
    @ApiModelProperty(notes = "个人地址")
    private String address;
    @ApiModelProperty(notes = "用户邮箱")
    @Email(message = "{gc.starter.validator.email}")
    private String email;
}
