package com.gccloud.starter.common.module.user.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.gccloud.starter.common.constant.GlobalConst;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 用户信息导出模板
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class SysUserExportTemplate implements Serializable {
    @ApiModelProperty(notes = "账号ID")
    @ExcelProperty(value = "账号ID", index = 10)
    private String id;
    @ApiModelProperty(notes = "权重(权重越大，排名越靠前)")
    @ExcelProperty(value = "权重", index = 20)
    private Integer weight;
    @ApiModelProperty(notes = "员工工号")
    @ExcelProperty(value = "员工工号", index = 20)
    private String jobNumber;
    @ApiModelProperty(notes = "账号")
    @ExcelProperty(value = "账号", index = 20)
    private String username;
    @ApiModelProperty(notes = "真实姓名")
    @ExcelProperty(value = "真实姓名", index = 20)
    private String realName;
    @ApiModelProperty(notes = "用户昵称")
    @ExcelProperty(value = "用户昵称", index = 20)
    private String nickname;
    /**
     * 参考 {@link GlobalConst.User.Status}
     */
    @ApiModelProperty(notes = "用户状态，1表示正常，0表示禁用")
    @ExcelProperty(value = "用户状态", index = 20)
    private Integer status;
    @ApiModelProperty(notes = "身份证号")
    @ExcelProperty(value = "身份证号", index = 20)
    private String idCard;
    @ApiModelProperty(notes = "头像存储路径")
    @ExcelProperty(value = "头像存储路径", index = 20)
    private String avatar;
    @ApiModelProperty(notes = "性别,0表示女性，1表示男性")
    @ExcelProperty(value = "性别", index = 20)
    private Integer gender;
    @ApiModelProperty(notes = "用户邮箱")
    @ExcelProperty(value = "用户邮箱", index = 20)
    private String email;
    @ApiModelProperty(notes = "手机号码")
    @ExcelProperty(value = "手机号码", index = 20)
    private String phone;
    @ApiModelProperty(notes = "办公电话")
    @ExcelProperty(value = "办公电话", index = 20)
    private String officeTel;
    @ApiModelProperty(notes = "QQ")
    @ExcelProperty(value = "QQ", index = 20)
    private String qq;
    @ApiModelProperty(notes = "微信")
    @ExcelProperty(value = "微信", index = 20)
    private String wx;
    @ApiModelProperty(notes = "工作单位")
    @ExcelProperty(value = "工作单位", index = 20)
    private String company;
    @ApiModelProperty(notes = "工作职责")
    @ExcelProperty(value = "工作职责", index = 20)
    private String responsibility;
    @ApiModelProperty(notes = "家庭地址")
    @ExcelProperty(value = "家庭地址", index = 20)
    private String address;
    @ApiModelProperty(notes = "密码过期时间")
    @ExcelProperty(value = "密码过期时间", index = 20)
    private Date pwdExpireDate;
    @ApiModelProperty(notes = "最后密码修改时间")
    @ExcelProperty(value = "最后密码修改时间", index = 20)
    private Date lastPwdUpdateDate;
    @ApiModelProperty(notes = "最后登录时间")
    @ExcelProperty(value = "最后登录时间", index = 20)
    private Date lastLoginDate;
    @ApiModelProperty(notes = "最后登录IP")
    @ExcelProperty(value = "最后登录IP", index = 20)
    private String lastLoginIp;
    @ApiModelProperty(notes = "归属公司")
    @ExcelProperty(value = "归属公司", index = 20)
    private String companyId;
}
