package com.gccloud.starter.common.module.user.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.gccloud.starter.common.entity.ExtendObj;
import com.gccloud.starter.extend.field.vo.SysUserVOExtend;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 返回数据给客户端
 * 可以忽略掉其中关键字段
 *
 * @author liuchengbiao
 * @date 2020-06-12 15:04
 */
@Data
@ExcelIgnoreUnannotated
public class SysUserVO extends SysUserVOExtend implements Serializable {

    @ApiModelProperty(notes = "主键")
    private String id;

    @ExcelProperty(value = "登录账号",index = 0)
    @ColumnWidth(value = 15)
    @ApiModelProperty(notes = "用户名")
    private String username;

    @ApiModelProperty(notes = "所属机构id")
    private String orgId;

    @ExcelProperty(value = "所属机构名称",index = 19)
    @ColumnWidth(value = 15)
    @ApiModelProperty(notes = "所属机构名称")
    private String orgName;

    @ExcelProperty(value = "姓名",index = 7)
    @ColumnWidth(value = 15)
    @ApiModelProperty(notes = "真实姓名")
    private String realName;

    @ExcelProperty(value = "工号",index = 8)
    @ColumnWidth(value = 15)
    @ApiModelProperty(notes = "工号")
    private String jobNumber;

    @ExcelProperty(value = "手机号",index = 5)
    @ColumnWidth(value = 15)
    @ApiModelProperty(notes = "手机号")
    private String phone;

    @ExcelProperty(value = "邮箱",index = 6)
    @ColumnWidth(value = 20)
    @ApiModelProperty(notes = "用户邮箱")
    private String email;

    @ExcelProperty(value = "办公电话",index = 9)
    @ColumnWidth(value = 15)
    @ApiModelProperty(notes = "办公电话")
    private String officeTel;

    @ExcelProperty(value = "QQ",index = 10)
    @ColumnWidth(value = 15)
    @ApiModelProperty(notes = "QQ")
    private String qq;

    @ExcelProperty(value = "微信",index = 11)
    @ColumnWidth(value = 15)
    @ApiModelProperty(notes = "微信")
    private String wx;

    @ExcelProperty(value = "昵称",index = 12)
    @ColumnWidth(value = 15)
    @ApiModelProperty(notes = "昵称")
    private String nickname;

    @ApiModelProperty(notes = "性别,0表示女性，1表示男性")
    private Integer gender;

    @ApiModelProperty(notes = "性别汉化字段")
    private String genderName;

    @ExcelProperty(value = "工作单位",index = 14)
    @ColumnWidth(value = 15)
    @ApiModelProperty(notes = "工作单位")
    private String company;

    @ApiModelProperty(notes = "归属公司ID")
    private String companyId;

    @ExcelProperty(value = "工作职责",index = 15)
    @ColumnWidth(value = 15)
    @ApiModelProperty(notes = "工作职责")
    private String responsibility;

    @ExcelProperty(value = "家庭地址",index = 16)
    @ColumnWidth(value = 15)
    @ApiModelProperty(notes = "家庭地址")
    private String address;

    @ExcelProperty(value = "权重",index = 17)
    @ColumnWidth(value = 12)
    @ApiModelProperty(notes = "权重(权重越大，排名越靠前)")
    private Integer weight;

    @ApiModelProperty(notes = "身份证号")
    private String idCard;

    @ApiModelProperty(notes = "用户状态")
    private Integer status;

    @ExcelProperty(value = "密码过期时间",index = 2)
    @ColumnWidth(value = 20)
    @ApiModelProperty(notes = "密码过期时间")
    private Date pwdExpireDate;

    @ExcelProperty(value = "密码修改时间",index = 3)
    @ColumnWidth(value = 20)
    @ApiModelProperty(notes = "密码修改时间")
    private Date lastPwdUpdateDate;

    /**
     * 用户分析用户登录的一个状态
     */
    @ExcelProperty(value = "最后登陆时间",index = 4)
    @ColumnWidth(value = 20)
    @ApiModelProperty(notes = "最后登录时间")
    private Date lastLoginDate;

    @ApiModelProperty(notes = "头像存储路径")
    private String avatar;

    @ApiModelProperty(notes = "最后登录IP")
    private String lastLoginIp;

    @ApiModelProperty(notes = "扩展对象(JSON格式)")
    private ExtendObj extendObj;
    /**
     * 角色名称
     */
    @ApiModelProperty(notes = "角色名称")
    private String roleName;
    /**
     * 岗位名称
     */
    @ApiModelProperty(notes = "工作岗位")
    private String postName;
    /**
     * 角色ID列表
     */
    @ApiModelProperty(notes = "角色ID列表")
    private List<String> roleIdList;
    /**
     * 岗位哦ID列表
     */
    @ApiModelProperty(notes = "岗位ID列表")
    private List<String> postIdList;

    @ApiModelProperty(notes = "所属机构ID集合")
    private List<String> belongOrgIdList;

    @ApiModelProperty(notes = "管理机构ID集合")
    private List<String> manageOrgIdList;

    @ApiModelProperty(notes = "账户是否可修改")
    private Integer usernameUpdated;
}
