package com.gccloud.starter.common.mybatis.injector;

import com.baomidou.mybatisplus.core.injector.AbstractMethod;
import com.baomidou.mybatisplus.core.injector.DefaultSqlInjector;
import com.baomidou.mybatisplus.core.injector.methods.*;
import com.gccloud.starter.common.constant.GlobalConst;
import com.gccloud.starter.common.mybatis.injector.methods.SelectPage;
import com.gccloud.starter.common.mybatis.injector.methods.*;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.List;

/**
 * SQL 注入器
 *
 * @author liuchengbiao
 * @date 2020-06-24 16:53
 */
@Slf4j
@Component
@ConditionalOnProperty(prefix = "gc.starter.component", name = "StarterSqlInjector", havingValue = "StarterSqlInjector",matchIfMissing = true)
public class StarterSqlInjector extends DefaultSqlInjector {

    @PostConstruct
    public void init() {
        log.info(GlobalConst.Console.LINE);
        log.info("启动框架默认的MyBatisPlus SQL注入器，解决了 select * 问题； 新增了数据权限方法-WithDp结尾");
        log.info(GlobalConst.Console.LINE);
    }

    @Override
    public List<AbstractMethod> getMethodList(Class<?> mapperClass) {
        // List<AbstractMethod> methodList = super.getMethodList(mapperClass);
        List<AbstractMethod> methodList = Lists.newArrayList(new Insert(),
                new Delete(),
                new DeleteByMap(),
                new DeleteById(),
                new DeleteBatchByIds(),
                new Update(),
                new UpdateById(),
                new com.gccloud.starter.common.mybatis.injector.methods.SelectById(),
                new com.gccloud.starter.common.mybatis.injector.methods.SelectBatchByIds(),
                new com.gccloud.starter.common.mybatis.injector.methods.SelectByMap(),
                new com.gccloud.starter.common.mybatis.injector.methods.SelectOne(),
                new SelectCount(),
                new com.gccloud.starter.common.mybatis.injector.methods.SelectMaps(),
                new com.gccloud.starter.common.mybatis.injector.methods.SelectMapsPage(),
                new SelectObjs(),
                new com.gccloud.starter.common.mybatis.injector.methods.SelectList(),
                new SelectPage());
        methodList.add(new DeleteBatchByIdsWithDp());
        methodList.add(new DeleteByIdWithDp());
        methodList.add(new DeleteByMapWithDp());
        methodList.add(new DeleteWithDp());
        methodList.add(new SelectBatchByIdsWithDp());
        methodList.add(new SelectByIdWithDp());
        methodList.add(new SelectByMapWithDp());
        methodList.add(new SelectCountWithDp());
        methodList.add(new SelectListWithDp());
        methodList.add(new SelectMapsPageWithDp());
        methodList.add(new SelectMapsWithDp());
        methodList.add(new SelectObjsWithDp());
        methodList.add(new SelectOneWithDp());
        methodList.add(new SelectPageWithDp());
        methodList.add(new UpdateByIdWithDp());
        methodList.add(new UpdateWithDp());
        return methodList;
    }
}
