package com.gccloud.starter.common.mybatis.parser;

import com.baomidou.mybatisplus.autoconfigure.MybatisPlusProperties;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.parser.SqlInfo;
import com.baomidou.mybatisplus.extension.plugins.pagination.optimize.JsqlParserCountOptimize;
import com.gccloud.starter.common.constant.GlobalConst;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.reflection.MetaObject;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;

/**
 * 解决 udal 丢失注解问题
 *
 * @author liuchengbiao
 * @date 2021/7/21 8:35 上午
 */
@Slf4j
@Component
@ConditionalOnProperty(prefix = "mybatis-plus.configuration.variables.udal", name = "countSqlParserEnable", havingValue = "true", matchIfMissing = false)
public class UdalCountSqlParser extends JsqlParserCountOptimize {

    @Resource
    private MybatisPlusProperties mybatisPlusProperties;

    private String shardingCommentHint;

    public UdalCountSqlParser() {
        log.info(GlobalConst.Console.LINE);
        log.info("启动UDAL自定义分页count解析器填充注解");
        log.info(GlobalConst.Console.LINE);
    }

    @PostConstruct
    public void init() {
        MybatisConfiguration configuration = mybatisPlusProperties.getConfiguration();
        this.shardingCommentHint = configuration.getVariables().getProperty("udal.shardingCommentHint");
    }

    @Override
    public SqlInfo parser(MetaObject metaObject, String orgSql) {
        SqlInfo sqlInfo = super.parser(metaObject, orgSql);
        String newSql = sqlInfo.getSql();
        if (orgSql.startsWith(this.shardingCommentHint) && !newSql.startsWith(this.shardingCommentHint)) {
            // 补上丢失的注解
            sqlInfo.setSql(this.shardingCommentHint + " \n" + newSql);
        }
        return sqlInfo;
    }
}