package com.gccloud.starter.common.mybatis.typeHandler;

import com.alibaba.fastjson.JSON;
import com.gccloud.starter.common.entity.ExtendObj;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * 扩展类型转换器
 */
@MappedTypes(ExtendObj.class)
@MappedJdbcTypes(JdbcType.VARCHAR)
public class ExtendObjJsonTypeHandler extends BaseTypeHandler<ExtendObj> {

    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, ExtendObj parameter, JdbcType jdbcType) throws SQLException {
        String val = "";
        if (parameter != null) {
            val = JSON.toJSONString(parameter);
        }
        ps.setString(i, val);
    }

    @Override
    public ExtendObj getNullableResult(ResultSet rs, String columnName) throws SQLException {
        String data = rs.getString(columnName);
        if (StringUtils.isBlank(data)) {
            return null;
        }
        return JSON.parseObject(data, ExtendObj.class);
    }

    @Override
    public ExtendObj getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        String data = rs.getString(columnIndex);
        if (StringUtils.isBlank(data)) {
            return null;
        }
        return JSON.parseObject(data, ExtendObj.class);
    }

    @Override
    public ExtendObj getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        String data = cs.getString(columnIndex);
        if (StringUtils.isBlank(data)) {
            return null;
        }
        return JSON.parseObject(data, ExtendObj.class);
    }
}