package com.gccloud.starter.common.utils;

import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.ReflectionUtils;

/**
 * 全局工具类
 * 列举了一些常用的工具类，算是工具类的一个入口，后端会定期更新；
 *
 * @author liuchengbiao
 * @date 2020-07-14 21:06
 */
public class GlobalUtils {

    public GlobalUtils() {
        throw new IllegalStateException("不允许创建");
    }

    /**
     * IP工具类
     */
    public static final class Ip extends IPUtils {
    }

    /**
     * HTTP工具类
     */
    public static final class Http extends HttpUtils {
    }

    /**
     * Spring 工具类
     */
    public static final class SpringContext extends SpringContextUtils {

    }

    /**
     * bean 工具类
     */
    public static final class Bean extends BeanConvertUtils {
    }

    /**
     * 字符串工具类
     */
    public static final class String extends StringUtils {
    }

    /**
     * 数组工具类
     */
    public static final class Array extends ArrayUtils {

    }

    /**
     * json工具类
     */
    public static final class Json extends com.alibaba.fastjson.JSON {

    }

    /**
     * 操作文件名的工具类
     * 可以获取用来获取文件名后缀；文件路径；文件名等信息
     */
    public static final class FileName extends FilenameUtils {

    }

    /**
     * 操作文件的工具类
     */
    public static final class File extends FileUtils {

    }

    /**
     * 操作IO的工具类
     */
    public static final class IO extends IOUtils {

    }

    /**
     * 反射工具类
     */
    public static final class Reflection extends ReflectionUtils {

    }

    /**
     * cookie工具类
     */
    public static final class Cookie extends CookieUtils {

    }
}
