package com.gccloud.starter.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.util.Base64Utils;

/**
 * jwt工具类
 *
 * @author liuchengbiao
 * @date 2021/7/6 2:17 下午
 */
@Slf4j
public class JwtUtils {

    /**
     * 解析jwt,不进行安全校验
     *
     * @param token
     * @return
     */
    public static JSONObject parseWithOutValidate(String token) {
        try {
            String payloadBase64 = StringUtils.substringBetween(token, ".");
            String payload;
            // 包含-说明是Base64UrlCodec编码的，该编码方式会将"+"、"/"替换为"-"、"_"
            if (payloadBase64.contains("-") || payloadBase64.contains("_")) {
                payload = new String(Base64Utils.decodeFromUrlSafeString(payloadBase64));
            } else {
                payload = new String(Base64Utils.decodeFromString(payloadBase64));
            }
            JSONObject tokenObj = JSON.parseObject(payload);
            return tokenObj;
        } catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace(e));
        }
        return null;
    }

    public static void main(String[] args) {
        JSONObject data = parseWithOutValidate("eyJhbGciOiJIUzI1NiJ9.eyJ1aWQiOiI4IiwiYXVkIjoiOCIsInVuYW1lIjoiZGVwYXJ0bWVudDEiLCJybmFtZSI6IuWkhOWupOi0n-i0o-S6uua1i-ivlSIsImlzcyI6InNjbS1vYSIsIm9pZCI6IjMiLCJpZCI6IjhfMTQ5ODgzODAzNjk3ODQxNzY2NiIsImV4cCI6MTY0NjI3MjIwOSwiaWF0IjoxNjQ2MTg1ODA5LCJ0aWQiOiIyIiwianRpIjoiOF8xNDk4ODM4MDM2OTc4NDE3NjY2In0.9839mwDvqORs_zMaZ72awlC-wrqXGIxiVFBpCGI69aU");
        System.out.println(data);
    }
}
