package com.gccloud.starter.common.utils;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.gccloud.starter.common.exception.GlobalException;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class LambdaUtils {

    /**
     * 获取属性名
     *
     * @param func
     * @param <T>
     * @return
     */
    public static <T> String getFieldName(SFunction<T, ?> func) {
        String implMethodName = com.baomidou.mybatisplus.core.toolkit.LambdaUtils.resolve(func).getImplMethodName();
        String prefix = null;
        if (implMethodName.startsWith("get")) {
            prefix = "get";
        } else if (implMethodName.startsWith("is")) {
            prefix = "is";
        }
        if (prefix == null) {
            throw new GlobalException("无效的getter方法: " + implMethodName);
        }
        implMethodName = implMethodName.replace(prefix, "");
        String fieldName = Character.toLowerCase(implMethodName.charAt(0)) + implMethodName.substring(1);
        return fieldName;
    }

}
