package com.gccloud.starter.common.utils;

import com.gccloud.starter.common.constant.GlobalConst;
import com.gccloud.starter.common.config.bean.Jwt;
import org.apache.commons.lang3.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.Set;

/**
 * @author liuchengbiao
 * @date 2020-07-16 16:51
 */
public class TokenUtils {

    public TokenUtils() {
        throw new IllegalStateException("不允许创建");
    }

    public static String getToken(HttpServletRequest request, Jwt jwt) {
        return getToken(request, jwt.getTokenKey(), jwt);
    }

    public static String getToken(HttpServletRequest request, String tokenKey, Jwt jwt) {
        // 从header中获取token
        if (jwt == null) {
            String token = CookieUtils.getValue(request, tokenKey);
            if (StringUtils.isBlank(token)) {
                token = request.getHeader(tokenKey);
            }
            if (StringUtils.isBlank(token)) {
                // 如果header中不存在token，则从参数中获取token
                token = request.getParameter(tokenKey);
            }
            return token;
        }
        Set<String> allowTakeMethod = jwt.getAllowTakeMethod();
        if (allowTakeMethod.contains(GlobalConst.Jwt.AllowTakeMethod.COOKIES)) {
            String token = CookieUtils.getValue(request, tokenKey);
            if (StringUtils.isNotBlank(token)) {
                return token;
            }
        }
        if (allowTakeMethod.contains(GlobalConst.Jwt.AllowTakeMethod.HEADER)) {
            String token = request.getHeader(tokenKey);
            if (StringUtils.isNotBlank(token)) {
                return token;
            }
        }
        if (allowTakeMethod.contains(GlobalConst.Jwt.AllowTakeMethod.PARAMETER)) {
            String token = request.getParameter(tokenKey);
            if (StringUtils.isNotBlank(token)) {
                return token;
            }
        }
        return null;
    }

    /**
     * 获取token
     *
     * @param request
     * @return
     */
    public static String getToken(HttpServletRequest request, String tokenKey) {
        return getToken(request, tokenKey, null);
    }

}
