package com.gccloud.starter.common.validator;

import com.gccloud.starter.common.validator.annotation.UUID;
import org.apache.commons.lang3.StringUtils;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.regex.Pattern;

/**
 * 密码校验器
 *
 * @author liuchengbiao
 * @date 2019-10-22 21:19
 */
public class UuidValidator implements ConstraintValidator<UUID, String> {
    /**
     * uuid校验器
     */

    public static final Pattern UUID_PATTERN = Pattern.compile("[a-zA-Z0-9-]{36}");

    @Override
    public boolean isValid(String uuid, ConstraintValidatorContext context) {
        if (StringUtils.isBlank(uuid)) {
            return true;
        }
        return UUID_PATTERN.matcher(uuid).matches();
    }

    /**
     * 校验uuid
     *
     * @param uuid
     * @return true: 合法，false: 不合法
     */
    public static boolean isValid(String uuid) {
        if (StringUtils.isBlank(uuid)) {
            return false;
        }
        return UUID_PATTERN.matcher(uuid).matches();
    }
}
