package com.gccloud.starter.common.validator.annotation;


import com.gccloud.starter.common.validator.UuidValidator;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * UUID校验
 *
 * @author liuchengbiao
 * @date 2019-10-22 21:20
 */
@Target({ElementType.METHOD, ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Constraint(validatedBy = UuidValidator.class)
public @interface UUID {

    String message() default "UUID格式不正确";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};
}