package com.gccloud.starter.common.validator.config;

import lombok.Data;

import java.util.regex.Pattern;

@Data
public class FieldRule {
    private String rule;
    private String message;
    // 不允许进行set
    private Pattern pattern;

    public FieldRule() {
    }

    public FieldRule(String rule, String message) {
        this.rule = rule;
        this.message = message;
    }

    public void setPattern(Pattern pattern) {
        // 不允许进行set
    }

    /**
     * 获取校验器
     *
     * @return
     */
    public synchronized Pattern getPattern() {
        if (pattern == null) {
            pattern = Pattern.compile(rule);
        }
        return pattern;
    }

    @Override
    public String toString() {
        return "{" +
                "rule='" + rule + '\'' +
                ", message='" + message + '\'' +
                '}';
    }
}
