package com.gccloud.starter.common.validator.config;

import com.gccloud.starter.common.validator.module.area.AreaEntityRule;
import com.gccloud.starter.common.validator.module.category.CategoryEntityRule;
import com.gccloud.starter.common.validator.module.company.CompanyEntityRule;
import com.gccloud.starter.common.validator.module.dict.DictEntityRule;
import com.gccloud.starter.common.validator.module.org.OrgEntityRule;
import com.gccloud.starter.common.validator.module.post.PostEntityRule;
import com.gccloud.starter.common.validator.module.role.RoleEntityRule;
import com.gccloud.starter.common.validator.module.user.UserEntityRule;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

/**
 * @author liuchengbiao
 * @date 2021/3/1 5:48 下午
 */
@Configuration
@ConfigurationProperties(prefix = "gc.starter.validator")
@PropertySource("classpath:/ValidationMessages.properties")
@Data
public class ValidationRuleConfig {
    /**
     * 用户管理规则校验
     */
    private UserEntityRule user = new UserEntityRule();
    // 在下面添加其他的模块的校验
    /**
     * 机构管理规则校验
     */
    private OrgEntityRule org = new OrgEntityRule();
    /**
     * 角色管理校验规则
     */
    private RoleEntityRule role = new RoleEntityRule();
    /**
     * 分类字典校验规则
     */
    private CategoryEntityRule category = new CategoryEntityRule();
    /**
     * 岗位规则校验
     */
    private PostEntityRule post = new PostEntityRule();
    /**
     * 公司规则校验
     */
    private CompanyEntityRule company = new CompanyEntityRule();
    /**
     * 区域规则校验
     */
    private AreaEntityRule area = new AreaEntityRule();
    /**
     * 业务字典规则校验
     */
    private DictEntityRule dict = new DictEntityRule();
}
