package com.gccloud.starter.common.validator.module.org;

import com.gccloud.starter.common.utils.SpringContextUtils;
import com.gccloud.starter.common.validator.config.ValidationRuleConfig;
import org.apache.commons.lang3.StringUtils;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * @author hongyang
 * @version 1.0
 * @date 2021/10/29 17:33
 */
public class ContactValidator implements ConstraintValidator<Contact, String> {

    @Override
    public boolean isValid(String contact, ConstraintValidatorContext context) {
        if (StringUtils.isBlank(contact)) {
            return true;
        }
        ValidationRuleConfig validationRuleConfig = SpringContextUtils.getBean(ValidationRuleConfig.class);
        return validationRuleConfig.getOrg().getContact().getPattern().matcher(contact).matches();
    }
}