package com.gccloud.starter.common.validator.module.role;

import com.gccloud.starter.common.utils.SpringContextUtils;
import com.gccloud.starter.common.validator.config.ValidationRuleConfig;
import org.apache.commons.lang3.StringUtils;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * @author hongyang
 * @version 1.0
 * @date 2021/10/29 17:38
 */
public class CodeValidator implements ConstraintValidator<Code, String> {

    @Override
    public boolean isValid(String contact, ConstraintValidatorContext context) {
        if (StringUtils.isBlank(contact)) {
            return true;
        }
        ValidationRuleConfig validationRuleConfig = SpringContextUtils.getBean(ValidationRuleConfig.class);
        return validationRuleConfig.getRole().getCode().getPattern().matcher(contact).matches();
    }
}