package com.gccloud.starter.common.validator.module.user;

import com.gccloud.starter.common.utils.SpringContextUtils;
import com.gccloud.starter.common.validator.config.ValidationRuleConfig;
import org.apache.commons.lang3.StringUtils;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * 密码校验器
 *
 * @author liuchengbiao
 * @date 2021年03月02日13:44:07
 */
public class PasswordValidator implements ConstraintValidator<Password, String> {

    @Override
    public boolean isValid(String contact, ConstraintValidatorContext context) {
        if (StringUtils.isBlank(contact)) {
            return true;
        }
        ValidationRuleConfig validationRuleConfig = SpringContextUtils.getBean(ValidationRuleConfig.class);
        return validationRuleConfig.getUser().getPassword().getPattern().matcher(contact).matches();
    }
}
