package com.gccloud.starter.common.validator.module.user;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author hongyang
 * @version 1.0
 * @date 2021/10/29 17:32
 */
@Target({ElementType.METHOD, ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Constraint(validatedBy = UsernameValidator.class)
public @interface Username {
    String message() default "登录账号必须是英文或数字";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};
}
