package com.gccloud.starter.common.validator.module.user;

import com.gccloud.starter.common.utils.SpringContextUtils;
import com.gccloud.starter.common.validator.config.ValidationRuleConfig;
import org.apache.commons.lang3.StringUtils;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * @author hongyang
 * @version 1.0
 * @date 2021/10/29 17:33
 */
public class UsernameValidator implements ConstraintValidator<Username, String> {

    @Override
    public boolean isValid(String username, ConstraintValidatorContext context) {
        if (StringUtils.isBlank(username)) {
            return true;
        }
        ValidationRuleConfig validationRuleConfig = SpringContextUtils.getBean(ValidationRuleConfig.class);
        return validationRuleConfig.getUser().getUsername().getPattern().matcher(username).matches();
    }
}