package com.gccloud.starter.common.vo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.gccloud.starter.common.constant.GlobalConst;
import com.gccloud.starter.common.entity.SysMenuEntity;
import com.gccloud.starter.common.entity.SysRoleEntity;
import com.gccloud.starter.common.module.role.vo.SysRoleVO;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 登录的用户
 *
 * @author liuchengbiao
 * @date 2020-06-21 19:58
 */
@Data
@Slf4j
public class CurrentUserBase {
    /**
     * 标识用户在服务器中的唯一身份
     */
    @JsonIgnore
    private String tokenId;
    /**
     * 用户的主键
     */
    private String id;
    /**
     * 用户账号
     */
    private String name;
    /**
     * 用户真实名称
     */
    private String realName;
    /**
     * 所属租户
     */
    private String tenantId;
    /**
     * 所属机构
     */
    private String orgId;
    /**
     * 当前用户权限集合
     */
    private Set<String> permissions;
    /**
     * 角色编码集合
     */
    private Set<String> roleCodes;
    /**
     * 数据规则
     * key: 规则编码
     * value: 对应的规则
     */
    private Map<String, SysMenuEntity> dataRuleMap;

    /**
     * 设置角色编码
     *
     * @param roleList
     */
    public void setRoleListByVo(List<SysRoleVO> roleList, String moduleCode) {
        roleCodes = Sets.newHashSet();
        if (roleList == null) {
            return;
        }
        for (SysRoleVO role : roleList) {
            if (moduleCode.equals(role.getModuleCode())) {
                roleCodes.add(role.getCode());
            }
        }
    }

    /**
     * 设置角色编码
     *
     * @param roleList
     */
    public void setRoleListByEntity(List<SysRoleEntity> roleList, String moduleCode) {
        roleCodes = Sets.newHashSet();
        if (roleList == null) {
            return;
        }
        for (SysRoleEntity role : roleList) {
            if (moduleCode.equals(role.getModuleCode())) {
                roleCodes.add(role.getCode());
            }
        }
    }

    /**
     * 数据数据规则
     *
     * @param navList
     */
    public void setDataRule(List<SysMenuEntity> navList) {
        dataRuleMap = Maps.newHashMap();
        if (navList == null) {
            return;
        }
        navList.forEach((menu -> {
            Integer type = menu.getType();
            if (GlobalConst.Menu.Type.DATA_RULE == type) {
                SysMenuEntity oldDataRule = dataRuleMap.put(menu.getRuleCode(), menu);
                if (oldDataRule != null) {
                    log.error("数据规则编码: {} 重复拥有，请检查设置", oldDataRule.getRuleCode());
                }
            }
        }));
    }

    /**
     * 设置菜单权限
     *
     * @param navList
     */
    public void setPermissions(List<SysMenuEntity> navList) {
        permissions = Sets.newHashSet();
        if (navList == null) {
            return;
        }
        // 设置权限
        navList.forEach((menu -> {
            Integer type = menu.getType();
            if (GlobalConst.Menu.Type.BUTTON == type) {
                String permission = menu.getPermissions();
                if (StringUtils.isBlank(permission)) {
                    return;
                }
                permissions.addAll(Arrays.stream(permission.split(",")).collect(Collectors.toSet()));
            }
        }));
    }
}
