/*
 * Decompiled with CFR 0.152.
 */
package com.genesys.internal.authentication.model;

import com.genesys.internal.authentication.model.UserRole;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="This class describes the user in the system. Applicable to different entities (contact-center level user, application/service, cloud system admin)")
public class CloudUserDetails {
    @SerializedName(value="authorities")
    private UserRole authorities = null;
    @SerializedName(value="cmeUserName")
    private String cmeUserName = null;
    @SerializedName(value="contactCenterId")
    private String contactCenterId = null;
    @SerializedName(value="dbid")
    private Integer dbid = null;
    @SerializedName(value="environmentId")
    private String environmentId = null;
    @SerializedName(value="loginName")
    private String loginName = null;
    @SerializedName(value="username")
    private String username = null;

    public CloudUserDetails authorities(UserRole authorities) {
        this.authorities = authorities;
        return this;
    }

    @ApiModelProperty(required=true, value="Authorities assigned to the user.")
    public UserRole getAuthorities() {
        return this.authorities;
    }

    public void setAuthorities(UserRole authorities) {
        this.authorities = authorities;
    }

    public CloudUserDetails cmeUserName(String cmeUserName) {
        this.cmeUserName = cmeUserName;
        return this;
    }

    @ApiModelProperty(value="The username in Configuration Server. This property is not set for users who aren't in Configuration Server (for example, applications/services, cloud system admin and so on.)")
    public String getCmeUserName() {
        return this.cmeUserName;
    }

    public void setCmeUserName(String cmeUserName) {
        this.cmeUserName = cmeUserName;
    }

    public CloudUserDetails contactCenterId(String contactCenterId) {
        this.contactCenterId = contactCenterId;
        return this;
    }

    @ApiModelProperty(value="The ID of the contact center the user belongs to (if any).")
    public String getContactCenterId() {
        return this.contactCenterId;
    }

    public void setContactCenterId(String contactCenterId) {
        this.contactCenterId = contactCenterId;
    }

    public CloudUserDetails dbid(Integer dbid) {
        this.dbid = dbid;
        return this;
    }

    @ApiModelProperty(value="The DBID of the corresponding user record in Configuration Server. This is present if the user belongs to a contact center.")
    public Integer getDbid() {
        return this.dbid;
    }

    public void setDbid(Integer dbid) {
        this.dbid = dbid;
    }

    public CloudUserDetails environmentId(String environmentId) {
        this.environmentId = environmentId;
        return this;
    }

    @ApiModelProperty(value="The ID of the Genesys environment the user belongs to (if any).")
    public String getEnvironmentId() {
        return this.environmentId;
    }

    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    public CloudUserDetails loginName(String loginName) {
        this.loginName = loginName;
        return this;
    }

    @ApiModelProperty(value="The username in Configuration Server. This property is not set for users who aren't in Configuration Server (for example, applications/services, cloud system admin and so on.)")
    public String getLoginName() {
        return this.loginName;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    public CloudUserDetails username(String username) {
        this.username = username;
        return this;
    }

    @ApiModelProperty(required=true, value="The system-wide unique name of the user. For contact center users, this includes the userName in Configuration Server, the DBID in Configuration Server and the contact center ID. For non-Configuration Server users the username can have other formats.")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloudUserDetails cloudUserDetails = (CloudUserDetails)o;
        return Objects.equals(this.authorities, cloudUserDetails.authorities) && Objects.equals(this.cmeUserName, cloudUserDetails.cmeUserName) && Objects.equals(this.contactCenterId, cloudUserDetails.contactCenterId) && Objects.equals(this.dbid, cloudUserDetails.dbid) && Objects.equals(this.environmentId, cloudUserDetails.environmentId) && Objects.equals(this.loginName, cloudUserDetails.loginName) && Objects.equals(this.username, cloudUserDetails.username);
    }

    public int hashCode() {
        return Objects.hash(this.authorities, this.cmeUserName, this.contactCenterId, this.dbid, this.environmentId, this.loginName, this.username);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CloudUserDetails {\n");
        sb.append("    authorities: ").append(this.toIndentedString(this.authorities)).append("\n");
        sb.append("    cmeUserName: ").append(this.toIndentedString(this.cmeUserName)).append("\n");
        sb.append("    contactCenterId: ").append(this.toIndentedString(this.contactCenterId)).append("\n");
        sb.append("    dbid: ").append(this.toIndentedString(this.dbid)).append("\n");
        sb.append("    environmentId: ").append(this.toIndentedString(this.environmentId)).append("\n");
        sb.append("    loginName: ").append(this.toIndentedString(this.loginName)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

