/*
 * Decompiled with CFR 0.152.
 */
package com.genesys.internal.authentication.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class DefaultOAuth2AccessToken {
    @SerializedName(value="access_token")
    private String accessToken = null;
    @SerializedName(value="expires_in")
    private Integer expiresIn = null;
    @SerializedName(value="refresh_token")
    private String refreshToken = null;
    @SerializedName(value="scope")
    private String scope = null;
    @SerializedName(value="token_type")
    private String tokenType = null;

    public DefaultOAuth2AccessToken accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @ApiModelProperty(value="The access token.")
    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public DefaultOAuth2AccessToken expiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
        return this;
    }

    @ApiModelProperty(value="The time, in seconds, before the token expiration.")
    public Integer getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }

    public DefaultOAuth2AccessToken refreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    @ApiModelProperty(value="The refresh token.")
    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public DefaultOAuth2AccessToken scope(String scope) {
        this.scope = scope;
        return this;
    }

    @ApiModelProperty(value="The scope of the token.")
    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public DefaultOAuth2AccessToken tokenType(String tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    @ApiModelProperty(value="The type of access token &mdash; always 'bearer'.")
    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultOAuth2AccessToken defaultOAuth2AccessToken = (DefaultOAuth2AccessToken)o;
        return Objects.equals(this.accessToken, defaultOAuth2AccessToken.accessToken) && Objects.equals(this.expiresIn, defaultOAuth2AccessToken.expiresIn) && Objects.equals(this.refreshToken, defaultOAuth2AccessToken.refreshToken) && Objects.equals(this.scope, defaultOAuth2AccessToken.scope) && Objects.equals(this.tokenType, defaultOAuth2AccessToken.tokenType);
    }

    public int hashCode() {
        return Objects.hash(this.accessToken, this.expiresIn, this.refreshToken, this.scope, this.tokenType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DefaultOAuth2AccessToken {\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    expiresIn: ").append(this.toIndentedString(this.expiresIn)).append("\n");
        sb.append("    refreshToken: ").append(this.toIndentedString(this.refreshToken)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    tokenType: ").append(this.toIndentedString(this.tokenType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

