/*
 * Decompiled with CFR 0.152.
 */
package com.genesys.internal.authentication.api;

import com.genesys.internal.authentication.model.AuthSchemeLookupData;
import com.genesys.internal.authentication.model.ChangePasswordOperation;
import com.genesys.internal.authentication.model.CloudUserDetails;
import com.genesys.internal.authentication.model.DefaultOAuth2AccessToken;
import com.genesys.internal.authentication.model.ModelApiResponse;
import com.genesys.internal.common.ApiCallback;
import com.genesys.internal.common.ApiClient;
import com.genesys.internal.common.ApiException;
import com.genesys.internal.common.ApiResponse;
import com.genesys.internal.common.Configuration;
import com.genesys.internal.common.Pair;
import com.genesys.internal.common.ProgressRequestBody;
import com.genesys.internal.common.ProgressResponseBody;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class AuthenticationApi {
    private ApiClient apiClient;

    public AuthenticationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AuthenticationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call authorizeCall(String responseType, String redirectUri, String clientId, String authorization, String scope, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/oauth/authorize";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (responseType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("response_type", responseType));
        }
        if (scope != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("scope", scope));
        }
        if (redirectUri != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("redirect_uri", redirectUri));
        }
        if (clientId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("client_id", clientId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call authorizeValidateBeforeCall(String responseType, String redirectUri, String clientId, String authorization, String scope, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (responseType == null) {
            throw new ApiException("Missing the required parameter 'responseType' when calling authorize(Async)");
        }
        if (redirectUri == null) {
            throw new ApiException("Missing the required parameter 'redirectUri' when calling authorize(Async)");
        }
        if (clientId == null) {
            throw new ApiException("Missing the required parameter 'clientId' when calling authorize(Async)");
        }
        Call call = this.authorizeCall(responseType, redirectUri, clientId, authorization, scope, progressListener, progressRequestListener);
        return call;
    }

    public void authorize(String responseType, String redirectUri, String clientId, String authorization, String scope) throws ApiException {
        this.authorizeWithHttpInfo(responseType, redirectUri, clientId, authorization, scope);
    }

    public ApiResponse<Void> authorizeWithHttpInfo(String responseType, String redirectUri, String clientId, String authorization, String scope) throws ApiException {
        Call call = this.authorizeValidateBeforeCall(responseType, redirectUri, clientId, authorization, scope, null, null);
        return this.apiClient.execute(call);
    }

    public Call authorizeAsync(String responseType, String redirectUri, String clientId, String authorization, String scope, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.authorizeValidateBeforeCall(responseType, redirectUri, clientId, authorization, scope, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call changePasswordCall(ChangePasswordOperation request, String authorization, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ChangePasswordOperation localVarPostBody = request;
        String localVarPath = "/change-password";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call changePasswordValidateBeforeCall(ChangePasswordOperation request, String authorization, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling changePassword(Async)");
        }
        Call call = this.changePasswordCall(request, authorization, progressListener, progressRequestListener);
        return call;
    }

    public ModelApiResponse changePassword(ChangePasswordOperation request, String authorization) throws ApiException {
        ApiResponse<ModelApiResponse> resp = this.changePasswordWithHttpInfo(request, authorization);
        return resp.getData();
    }

    public ApiResponse<ModelApiResponse> changePasswordWithHttpInfo(ChangePasswordOperation request, String authorization) throws ApiException {
        Call call = this.changePasswordValidateBeforeCall(request, authorization, null, null);
        Type localVarReturnType = new TypeToken<ModelApiResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call changePasswordAsync(ChangePasswordOperation request, String authorization, final ApiCallback<ModelApiResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.changePasswordValidateBeforeCall(request, authorization, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ModelApiResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getInfoCall(String authorization, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/userinfo";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getInfoValidateBeforeCall(String authorization, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling getInfo(Async)");
        }
        Call call = this.getInfoCall(authorization, progressListener, progressRequestListener);
        return call;
    }

    public CloudUserDetails getInfo(String authorization) throws ApiException {
        ApiResponse<CloudUserDetails> resp = this.getInfoWithHttpInfo(authorization);
        return resp.getData();
    }

    public ApiResponse<CloudUserDetails> getInfoWithHttpInfo(String authorization) throws ApiException {
        Call call = this.getInfoValidateBeforeCall(authorization, null, null);
        Type localVarReturnType = new TypeToken<CloudUserDetails>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getInfoAsync(String authorization, final ApiCallback<CloudUserDetails> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getInfoValidateBeforeCall(authorization, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CloudUserDetails>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call retrieveTokenCall(String grantType, String authorization, String accept, String scope, String clientId, String refreshToken, String username, String password, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/oauth/token";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        if (accept != null) {
            localVarHeaderParams.put("Accept", this.apiClient.parameterToString(accept));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (grantType != null) {
            localVarFormParams.put("grant_type", grantType);
        }
        if (scope != null) {
            localVarFormParams.put("scope", scope);
        }
        if (clientId != null) {
            localVarFormParams.put("client_id", clientId);
        }
        if (refreshToken != null) {
            localVarFormParams.put("refresh_token", refreshToken);
        }
        if (username != null) {
            localVarFormParams.put("username", username);
        }
        if (password != null) {
            localVarFormParams.put("password", password);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call retrieveTokenValidateBeforeCall(String grantType, String authorization, String accept, String scope, String clientId, String refreshToken, String username, String password, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (grantType == null) {
            throw new ApiException("Missing the required parameter 'grantType' when calling retrieveToken(Async)");
        }
        Call call = this.retrieveTokenCall(grantType, authorization, accept, scope, clientId, refreshToken, username, password, progressListener, progressRequestListener);
        return call;
    }

    public DefaultOAuth2AccessToken retrieveToken(String grantType, String authorization, String accept, String scope, String clientId, String refreshToken, String username, String password) throws ApiException {
        ApiResponse<DefaultOAuth2AccessToken> resp = this.retrieveTokenWithHttpInfo(grantType, authorization, accept, scope, clientId, refreshToken, username, password);
        return resp.getData();
    }

    public ApiResponse<DefaultOAuth2AccessToken> retrieveTokenWithHttpInfo(String grantType, String authorization, String accept, String scope, String clientId, String refreshToken, String username, String password) throws ApiException {
        Call call = this.retrieveTokenValidateBeforeCall(grantType, authorization, accept, scope, clientId, refreshToken, username, password, null, null);
        Type localVarReturnType = new TypeToken<DefaultOAuth2AccessToken>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call retrieveTokenAsync(String grantType, String authorization, String accept, String scope, String clientId, String refreshToken, String username, String password, final ApiCallback<DefaultOAuth2AccessToken> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.retrieveTokenValidateBeforeCall(grantType, authorization, accept, scope, clientId, refreshToken, username, password, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DefaultOAuth2AccessToken>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call signInCall(String username, String password, Boolean saml, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/sign-in";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (username != null) {
            localVarFormParams.put("username", username);
        }
        if (password != null) {
            localVarFormParams.put("password", password);
        }
        if (saml != null) {
            localVarFormParams.put("saml", saml);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call signInValidateBeforeCall(String username, String password, Boolean saml, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (username == null) {
            throw new ApiException("Missing the required parameter 'username' when calling signIn(Async)");
        }
        if (password == null) {
            throw new ApiException("Missing the required parameter 'password' when calling signIn(Async)");
        }
        Call call = this.signInCall(username, password, saml, progressListener, progressRequestListener);
        return call;
    }

    public void signIn(String username, String password, Boolean saml) throws ApiException {
        this.signInWithHttpInfo(username, password, saml);
    }

    public ApiResponse<Void> signInWithHttpInfo(String username, String password, Boolean saml) throws ApiException {
        Call call = this.signInValidateBeforeCall(username, password, saml, null, null);
        return this.apiClient.execute(call);
    }

    public Call signInAsync(String username, String password, Boolean saml, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.signInValidateBeforeCall(username, password, saml, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call signOutCall(String authorization, Boolean global, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/sign-out";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (global != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("global", global));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call signOutValidateBeforeCall(String authorization, Boolean global, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling signOut(Async)");
        }
        Call call = this.signOutCall(authorization, global, progressListener, progressRequestListener);
        return call;
    }

    public ModelApiResponse signOut(String authorization, Boolean global) throws ApiException {
        ApiResponse<ModelApiResponse> resp = this.signOutWithHttpInfo(authorization, global);
        return resp.getData();
    }

    public ApiResponse<ModelApiResponse> signOutWithHttpInfo(String authorization, Boolean global) throws ApiException {
        Call call = this.signOutValidateBeforeCall(authorization, global, null, null);
        Type localVarReturnType = new TypeToken<ModelApiResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call signOutAsync(String authorization, Boolean global, final ApiCallback<ModelApiResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.signOutValidateBeforeCall(authorization, global, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ModelApiResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call signOut1Call(String authorization, Boolean global, String redirectUri, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/sign-out";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (global != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("global", global));
        }
        if (redirectUri != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("redirectUri", redirectUri));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call signOut1ValidateBeforeCall(String authorization, Boolean global, String redirectUri, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling signOut1(Async)");
        }
        Call call = this.signOut1Call(authorization, global, redirectUri, progressListener, progressRequestListener);
        return call;
    }

    public ModelApiResponse signOut1(String authorization, Boolean global, String redirectUri) throws ApiException {
        ApiResponse<ModelApiResponse> resp = this.signOut1WithHttpInfo(authorization, global, redirectUri);
        return resp.getData();
    }

    public ApiResponse<ModelApiResponse> signOut1WithHttpInfo(String authorization, Boolean global, String redirectUri) throws ApiException {
        Call call = this.signOut1ValidateBeforeCall(authorization, global, redirectUri, null, null);
        Type localVarReturnType = new TypeToken<ModelApiResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call signOut1Async(String authorization, Boolean global, String redirectUri, final ApiCallback<ModelApiResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.signOut1ValidateBeforeCall(authorization, global, redirectUri, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ModelApiResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call tenantInfoCall(AuthSchemeLookupData lookupData, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        AuthSchemeLookupData localVarPostBody = lookupData;
        String localVarPath = "/auth-scheme";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call tenantInfoValidateBeforeCall(AuthSchemeLookupData lookupData, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.tenantInfoCall(lookupData, progressListener, progressRequestListener);
        return call;
    }

    public ModelApiResponse tenantInfo(AuthSchemeLookupData lookupData) throws ApiException {
        ApiResponse<ModelApiResponse> resp = this.tenantInfoWithHttpInfo(lookupData);
        return resp.getData();
    }

    public ApiResponse<ModelApiResponse> tenantInfoWithHttpInfo(AuthSchemeLookupData lookupData) throws ApiException {
        Call call = this.tenantInfoValidateBeforeCall(lookupData, null, null);
        Type localVarReturnType = new TypeToken<ModelApiResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call tenantInfoAsync(AuthSchemeLookupData lookupData, final ApiCallback<ModelApiResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.tenantInfoValidateBeforeCall(lookupData, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ModelApiResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

