/*
 * Decompiled with CFR 0.152.
 */
package com.genesys.internal.engagement.api;

import com.genesys.internal.common.ApiCallback;
import com.genesys.internal.common.ApiClient;
import com.genesys.internal.common.ApiException;
import com.genesys.internal.common.ApiResponse;
import com.genesys.internal.common.Configuration;
import com.genesys.internal.common.Pair;
import com.genesys.internal.common.ProgressRequestBody;
import com.genesys.internal.common.ProgressResponseBody;
import com.genesys.internal.engagement.model.AvailabilitiesResponse200;
import com.genesys.internal.engagement.model.OpenForResponse200;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import org.threeten.bp.OffsetDateTime;

public class AvailabilityApi {
    private ApiClient apiClient;

    public AvailabilityApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AvailabilityApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call openForCall(String xApiKey, String serviceName, OffsetDateTime start, String timezone, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/callbacks/open-for/{service-name}".replaceAll("\\{service-name\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (start != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("start", start));
        }
        if (timezone != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("timezone", timezone));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xApiKey != null) {
            localVarHeaderParams.put("x-api-key", this.apiClient.parameterToString(xApiKey));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call openForValidateBeforeCall(String xApiKey, String serviceName, OffsetDateTime start, String timezone, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xApiKey == null) {
            throw new ApiException("Missing the required parameter 'xApiKey' when calling openFor(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling openFor(Async)");
        }
        Call call = this.openForCall(xApiKey, serviceName, start, timezone, progressListener, progressRequestListener);
        return call;
    }

    public OpenForResponse200 openFor(String xApiKey, String serviceName, OffsetDateTime start, String timezone) throws ApiException {
        ApiResponse<OpenForResponse200> resp = this.openForWithHttpInfo(xApiKey, serviceName, start, timezone);
        return resp.getData();
    }

    public ApiResponse<OpenForResponse200> openForWithHttpInfo(String xApiKey, String serviceName, OffsetDateTime start, String timezone) throws ApiException {
        Call call = this.openForValidateBeforeCall(xApiKey, serviceName, start, timezone, null, null);
        Type localVarReturnType = new TypeToken<OpenForResponse200>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call openForAsync(String xApiKey, String serviceName, OffsetDateTime start, String timezone, final ApiCallback<OpenForResponse200> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.openForValidateBeforeCall(xApiKey, serviceName, start, timezone, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OpenForResponse200>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call queryAvailabilityV2Call(String xApiKey, String serviceName, OffsetDateTime start, BigDecimal startMS, BigDecimal numberOfDays, OffsetDateTime end, BigDecimal endMS, String timezone, BigDecimal maxTimeSlots, Boolean reportBusy, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/callbacks/availability/{service-name}".replaceAll("\\{service-name\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (start != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("start", start));
        }
        if (startMS != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("startMS", startMS));
        }
        if (numberOfDays != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("numberOfDays", numberOfDays));
        }
        if (end != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("end", end));
        }
        if (endMS != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("endMS", endMS));
        }
        if (timezone != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("timezone", timezone));
        }
        if (maxTimeSlots != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("maxTimeSlots", maxTimeSlots));
        }
        if (reportBusy != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("reportBusy", reportBusy));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xApiKey != null) {
            localVarHeaderParams.put("x-api-key", this.apiClient.parameterToString(xApiKey));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call queryAvailabilityV2ValidateBeforeCall(String xApiKey, String serviceName, OffsetDateTime start, BigDecimal startMS, BigDecimal numberOfDays, OffsetDateTime end, BigDecimal endMS, String timezone, BigDecimal maxTimeSlots, Boolean reportBusy, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xApiKey == null) {
            throw new ApiException("Missing the required parameter 'xApiKey' when calling queryAvailabilityV2(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling queryAvailabilityV2(Async)");
        }
        Call call = this.queryAvailabilityV2Call(xApiKey, serviceName, start, startMS, numberOfDays, end, endMS, timezone, maxTimeSlots, reportBusy, progressListener, progressRequestListener);
        return call;
    }

    public AvailabilitiesResponse200 queryAvailabilityV2(String xApiKey, String serviceName, OffsetDateTime start, BigDecimal startMS, BigDecimal numberOfDays, OffsetDateTime end, BigDecimal endMS, String timezone, BigDecimal maxTimeSlots, Boolean reportBusy) throws ApiException {
        ApiResponse<AvailabilitiesResponse200> resp = this.queryAvailabilityV2WithHttpInfo(xApiKey, serviceName, start, startMS, numberOfDays, end, endMS, timezone, maxTimeSlots, reportBusy);
        return resp.getData();
    }

    public ApiResponse<AvailabilitiesResponse200> queryAvailabilityV2WithHttpInfo(String xApiKey, String serviceName, OffsetDateTime start, BigDecimal startMS, BigDecimal numberOfDays, OffsetDateTime end, BigDecimal endMS, String timezone, BigDecimal maxTimeSlots, Boolean reportBusy) throws ApiException {
        Call call = this.queryAvailabilityV2ValidateBeforeCall(xApiKey, serviceName, start, startMS, numberOfDays, end, endMS, timezone, maxTimeSlots, reportBusy, null, null);
        Type localVarReturnType = new TypeToken<AvailabilitiesResponse200>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call queryAvailabilityV2Async(String xApiKey, String serviceName, OffsetDateTime start, BigDecimal startMS, BigDecimal numberOfDays, OffsetDateTime end, BigDecimal endMS, String timezone, BigDecimal maxTimeSlots, Boolean reportBusy, final ApiCallback<AvailabilitiesResponse200> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.queryAvailabilityV2ValidateBeforeCall(xApiKey, serviceName, start, startMS, numberOfDays, end, endMS, timezone, maxTimeSlots, reportBusy, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AvailabilitiesResponse200>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

