/*
 * Decompiled with CFR 0.152.
 */
package com.genesys.internal.engagement.api;

import com.genesys.internal.common.ApiCallback;
import com.genesys.internal.common.ApiClient;
import com.genesys.internal.common.ApiException;
import com.genesys.internal.common.ApiResponse;
import com.genesys.internal.common.Configuration;
import com.genesys.internal.common.Pair;
import com.genesys.internal.common.ProgressRequestBody;
import com.genesys.internal.common.ProgressResponseBody;
import com.genesys.internal.engagement.model.CallbackIdParms;
import com.genesys.internal.engagement.model.CancelCallbackResponse200;
import com.genesys.internal.engagement.model.CreateCallbackParms;
import com.genesys.internal.engagement.model.CreateCallbackResponse200;
import com.genesys.internal.engagement.model.GetCallbackResponse200;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class CallbacksApi {
    private ApiClient apiClient;

    public CallbacksApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CallbacksApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call bookCallbackExternalCall(String xApiKey, CreateCallbackParms body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateCallbackParms localVarPostBody = body;
        String localVarPath = "/callbacks/create";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xApiKey != null) {
            localVarHeaderParams.put("x-api-key", this.apiClient.parameterToString(xApiKey));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call bookCallbackExternalValidateBeforeCall(String xApiKey, CreateCallbackParms body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xApiKey == null) {
            throw new ApiException("Missing the required parameter 'xApiKey' when calling bookCallbackExternal(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling bookCallbackExternal(Async)");
        }
        Call call = this.bookCallbackExternalCall(xApiKey, body, progressListener, progressRequestListener);
        return call;
    }

    public CreateCallbackResponse200 bookCallbackExternal(String xApiKey, CreateCallbackParms body) throws ApiException {
        ApiResponse<CreateCallbackResponse200> resp = this.bookCallbackExternalWithHttpInfo(xApiKey, body);
        return resp.getData();
    }

    public ApiResponse<CreateCallbackResponse200> bookCallbackExternalWithHttpInfo(String xApiKey, CreateCallbackParms body) throws ApiException {
        Call call = this.bookCallbackExternalValidateBeforeCall(xApiKey, body, null, null);
        Type localVarReturnType = new TypeToken<CreateCallbackResponse200>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call bookCallbackExternalAsync(String xApiKey, CreateCallbackParms body, final ApiCallback<CreateCallbackResponse200> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.bookCallbackExternalValidateBeforeCall(xApiKey, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CreateCallbackResponse200>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call cancelCallbackCall(String xApiKey, CallbackIdParms body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CallbackIdParms localVarPostBody = body;
        String localVarPath = "/callbacks/cancel";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xApiKey != null) {
            localVarHeaderParams.put("x-api-key", this.apiClient.parameterToString(xApiKey));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call cancelCallbackValidateBeforeCall(String xApiKey, CallbackIdParms body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xApiKey == null) {
            throw new ApiException("Missing the required parameter 'xApiKey' when calling cancelCallback(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling cancelCallback(Async)");
        }
        Call call = this.cancelCallbackCall(xApiKey, body, progressListener, progressRequestListener);
        return call;
    }

    public CancelCallbackResponse200 cancelCallback(String xApiKey, CallbackIdParms body) throws ApiException {
        ApiResponse<CancelCallbackResponse200> resp = this.cancelCallbackWithHttpInfo(xApiKey, body);
        return resp.getData();
    }

    public ApiResponse<CancelCallbackResponse200> cancelCallbackWithHttpInfo(String xApiKey, CallbackIdParms body) throws ApiException {
        Call call = this.cancelCallbackValidateBeforeCall(xApiKey, body, null, null);
        Type localVarReturnType = new TypeToken<CancelCallbackResponse200>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call cancelCallbackAsync(String xApiKey, CallbackIdParms body, final ApiCallback<CancelCallbackResponse200> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.cancelCallbackValidateBeforeCall(xApiKey, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CancelCallbackResponse200>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call queryCallbackByIdCall(String xApiKey, CallbackIdParms body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CallbackIdParms localVarPostBody = body;
        String localVarPath = "/callbacks/retrieve";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xApiKey != null) {
            localVarHeaderParams.put("x-api-key", this.apiClient.parameterToString(xApiKey));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call queryCallbackByIdValidateBeforeCall(String xApiKey, CallbackIdParms body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xApiKey == null) {
            throw new ApiException("Missing the required parameter 'xApiKey' when calling queryCallbackById(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling queryCallbackById(Async)");
        }
        Call call = this.queryCallbackByIdCall(xApiKey, body, progressListener, progressRequestListener);
        return call;
    }

    public GetCallbackResponse200 queryCallbackById(String xApiKey, CallbackIdParms body) throws ApiException {
        ApiResponse<GetCallbackResponse200> resp = this.queryCallbackByIdWithHttpInfo(xApiKey, body);
        return resp.getData();
    }

    public ApiResponse<GetCallbackResponse200> queryCallbackByIdWithHttpInfo(String xApiKey, CallbackIdParms body) throws ApiException {
        Call call = this.queryCallbackByIdValidateBeforeCall(xApiKey, body, null, null);
        Type localVarReturnType = new TypeToken<GetCallbackResponse200>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call queryCallbackByIdAsync(String xApiKey, CallbackIdParms body, final ApiCallback<GetCallbackResponse200> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.queryCallbackByIdValidateBeforeCall(xApiKey, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetCallbackResponse200>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

