/*
 * Decompiled with CFR 0.152.
 */
package com.genesys.internal.engagement.api;

import com.genesys.internal.common.ApiCallback;
import com.genesys.internal.common.ApiClient;
import com.genesys.internal.common.ApiException;
import com.genesys.internal.common.ApiResponse;
import com.genesys.internal.common.Configuration;
import com.genesys.internal.common.Pair;
import com.genesys.internal.common.ProgressRequestBody;
import com.genesys.internal.common.ProgressResponseBody;
import com.genesys.internal.engagement.model.EstimatedWaitTimeResponse200;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class EstimatedWaitTimeApi {
    private ApiClient apiClient;

    public EstimatedWaitTimeApi() {
        this(Configuration.getDefaultApiClient());
    }

    public EstimatedWaitTimeApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call estimatedWaitTimeAPI1Call(String xApiKey, String virtualQueues, String mode, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/estimated-wait-time";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (virtualQueues != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("virtual-queues", virtualQueues));
        }
        if (mode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("mode", mode));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xApiKey != null) {
            localVarHeaderParams.put("x-api-key", this.apiClient.parameterToString(xApiKey));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call estimatedWaitTimeAPI1ValidateBeforeCall(String xApiKey, String virtualQueues, String mode, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xApiKey == null) {
            throw new ApiException("Missing the required parameter 'xApiKey' when calling estimatedWaitTimeAPI1(Async)");
        }
        if (virtualQueues == null) {
            throw new ApiException("Missing the required parameter 'virtualQueues' when calling estimatedWaitTimeAPI1(Async)");
        }
        Call call = this.estimatedWaitTimeAPI1Call(xApiKey, virtualQueues, mode, progressListener, progressRequestListener);
        return call;
    }

    public EstimatedWaitTimeResponse200 estimatedWaitTimeAPI1(String xApiKey, String virtualQueues, String mode) throws ApiException {
        ApiResponse<EstimatedWaitTimeResponse200> resp = this.estimatedWaitTimeAPI1WithHttpInfo(xApiKey, virtualQueues, mode);
        return resp.getData();
    }

    public ApiResponse<EstimatedWaitTimeResponse200> estimatedWaitTimeAPI1WithHttpInfo(String xApiKey, String virtualQueues, String mode) throws ApiException {
        Call call = this.estimatedWaitTimeAPI1ValidateBeforeCall(xApiKey, virtualQueues, mode, null, null);
        Type localVarReturnType = new TypeToken<EstimatedWaitTimeResponse200>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call estimatedWaitTimeAPI1Async(String xApiKey, String virtualQueues, String mode, final ApiCallback<EstimatedWaitTimeResponse200> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.estimatedWaitTimeAPI1ValidateBeforeCall(xApiKey, virtualQueues, mode, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<EstimatedWaitTimeResponse200>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

