/*
 * Decompiled with CFR 0.152.
 */
package com.genesys.internal.engagement.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.UUID;

public class CallInRequest {
    @SerializedName(value="id")
    private UUID id = null;
    @SerializedName(value="toPhoneNumber")
    private String toPhoneNumber = null;
    @SerializedName(value="groupName")
    private String groupName = null;
    @SerializedName(value="expirationTime")
    private BigDecimal expirationTime = null;
    @SerializedName(value="accessCode")
    private BigDecimal accessCode = null;
    @SerializedName(value="fromPhoneNumber")
    private String fromPhoneNumber = null;
    @SerializedName(value="callbackServiceId")
    private UUID callbackServiceId = null;

    public CallInRequest id(UUID id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="8c78d4e1-c85a-424b-8334-5ff36e07372f", value="The Click-To-Call-In request ID.")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public CallInRequest toPhoneNumber(String toPhoneNumber) {
        this.toPhoneNumber = toPhoneNumber;
        return this;
    }

    @ApiModelProperty(example="+19059680004", value="Phone number to call.")
    public String getToPhoneNumber() {
        return this.toPhoneNumber;
    }

    public void setToPhoneNumber(String toPhoneNumber) {
        this.toPhoneNumber = toPhoneNumber;
    }

    public CallInRequest groupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    @ApiModelProperty(example="technical_help", value="Name of the Click-To-Call-In resource group.")
    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public CallInRequest expirationTime(BigDecimal expirationTime) {
        this.expirationTime = expirationTime;
        return this;
    }

    @ApiModelProperty(example="1.53781992821E11", value="Expiration time of the request in epoch time format.")
    public BigDecimal getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(BigDecimal expirationTime) {
        this.expirationTime = expirationTime;
    }

    public CallInRequest accessCode(BigDecimal accessCode) {
        this.accessCode = accessCode;
        return this;
    }

    @ApiModelProperty(example="123456.0", value="Access code to use.")
    public BigDecimal getAccessCode() {
        return this.accessCode;
    }

    public void setAccessCode(BigDecimal accessCode) {
        this.accessCode = accessCode;
    }

    public CallInRequest fromPhoneNumber(String fromPhoneNumber) {
        this.fromPhoneNumber = fromPhoneNumber;
        return this;
    }

    @ApiModelProperty(example="9059683457", value="Phone number associated with the request.")
    public String getFromPhoneNumber() {
        return this.fromPhoneNumber;
    }

    public void setFromPhoneNumber(String fromPhoneNumber) {
        this.fromPhoneNumber = fromPhoneNumber;
    }

    public CallInRequest callbackServiceId(UUID callbackServiceId) {
        this.callbackServiceId = callbackServiceId;
        return this;
    }

    @ApiModelProperty(value="Callback ID associated with the request.")
    public UUID getCallbackServiceId() {
        return this.callbackServiceId;
    }

    public void setCallbackServiceId(UUID callbackServiceId) {
        this.callbackServiceId = callbackServiceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CallInRequest callInRequest = (CallInRequest)o;
        return Objects.equals(this.id, callInRequest.id) && Objects.equals(this.toPhoneNumber, callInRequest.toPhoneNumber) && Objects.equals(this.groupName, callInRequest.groupName) && Objects.equals(this.expirationTime, callInRequest.expirationTime) && Objects.equals(this.accessCode, callInRequest.accessCode) && Objects.equals(this.fromPhoneNumber, callInRequest.fromPhoneNumber) && Objects.equals(this.callbackServiceId, callInRequest.callbackServiceId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.toPhoneNumber, this.groupName, this.expirationTime, this.accessCode, this.fromPhoneNumber, this.callbackServiceId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CallInRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    toPhoneNumber: ").append(this.toIndentedString(this.toPhoneNumber)).append("\n");
        sb.append("    groupName: ").append(this.toIndentedString(this.groupName)).append("\n");
        sb.append("    expirationTime: ").append(this.toIndentedString(this.expirationTime)).append("\n");
        sb.append("    accessCode: ").append(this.toIndentedString(this.accessCode)).append("\n");
        sb.append("    fromPhoneNumber: ").append(this.toIndentedString(this.fromPhoneNumber)).append("\n");
        sb.append("    callbackServiceId: ").append(this.toIndentedString(this.callbackServiceId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

