/*
 * Decompiled with CFR 0.152.
 */
package com.genesys.internal.engagement.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.OffsetDateTime;

public class Callback {
    @SerializedName(value="id")
    private UUID id = null;
    @SerializedName(value="desiredTime")
    private OffsetDateTime desiredTime = null;
    @SerializedName(value="callbackState")
    private String callbackState = null;
    @SerializedName(value="callbackReason")
    private String callbackReason = null;
    @SerializedName(value="phoneNumber")
    private String phoneNumber = null;
    @SerializedName(value="positionInQueue")
    private BigDecimal positionInQueue = null;
    @SerializedName(value="estimatedWaitTime")
    private BigDecimal estimatedWaitTime = null;

    public Callback id(UUID id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The callback ID.")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public Callback desiredTime(OffsetDateTime desiredTime) {
        this.desiredTime = desiredTime;
        return this;
    }

    @ApiModelProperty(value="Desired time of the callback in UTC.")
    public OffsetDateTime getDesiredTime() {
        return this.desiredTime;
    }

    public void setDesiredTime(OffsetDateTime desiredTime) {
        this.desiredTime = desiredTime;
    }

    public Callback callbackState(String callbackState) {
        this.callbackState = callbackState;
        return this;
    }

    @ApiModelProperty(value="Current state of the callback. Possible values are - SCHEDULED, QUEUED, ROUTING, PROCESSING, COMPLETED.")
    public String getCallbackState() {
        return this.callbackState;
    }

    public void setCallbackState(String callbackState) {
        this.callbackState = callbackState;
    }

    public Callback callbackReason(String callbackReason) {
        this.callbackReason = callbackReason;
        return this;
    }

    @ApiModelProperty(value="Provides a reason for completion. This is only provided if the callback is in a COMPLETED state.")
    public String getCallbackReason() {
        return this.callbackReason;
    }

    public void setCallbackReason(String callbackReason) {
        this.callbackReason = callbackReason;
    }

    public Callback phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @ApiModelProperty(value="Number to call back.")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public Callback positionInQueue(BigDecimal positionInQueue) {
        this.positionInQueue = positionInQueue;
        return this;
    }

    @ApiModelProperty(value="Position in queue. This property is only provided if the callback is in one of the following state - QUEUED, ROUTING, or PROCESSING.")
    public BigDecimal getPositionInQueue() {
        return this.positionInQueue;
    }

    public void setPositionInQueue(BigDecimal positionInQueue) {
        this.positionInQueue = positionInQueue;
    }

    public Callback estimatedWaitTime(BigDecimal estimatedWaitTime) {
        this.estimatedWaitTime = estimatedWaitTime;
        return this;
    }

    @ApiModelProperty(value="Expected waiting time (in seconds). This property is only provided if the callback is in one of the following state - QUEUED, ROUTING, or PROCESSING.")
    public BigDecimal getEstimatedWaitTime() {
        return this.estimatedWaitTime;
    }

    public void setEstimatedWaitTime(BigDecimal estimatedWaitTime) {
        this.estimatedWaitTime = estimatedWaitTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Callback callback = (Callback)o;
        return Objects.equals(this.id, callback.id) && Objects.equals(this.desiredTime, callback.desiredTime) && Objects.equals(this.callbackState, callback.callbackState) && Objects.equals(this.callbackReason, callback.callbackReason) && Objects.equals(this.phoneNumber, callback.phoneNumber) && Objects.equals(this.positionInQueue, callback.positionInQueue) && Objects.equals(this.estimatedWaitTime, callback.estimatedWaitTime);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.desiredTime, this.callbackState, this.callbackReason, this.phoneNumber, this.positionInQueue, this.estimatedWaitTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Callback {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    desiredTime: ").append(this.toIndentedString(this.desiredTime)).append("\n");
        sb.append("    callbackState: ").append(this.toIndentedString(this.callbackState)).append("\n");
        sb.append("    callbackReason: ").append(this.toIndentedString(this.callbackReason)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    positionInQueue: ").append(this.toIndentedString(this.positionInQueue)).append("\n");
        sb.append("    estimatedWaitTime: ").append(this.toIndentedString(this.estimatedWaitTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

