/*
 * Decompiled with CFR 0.152.
 */
package com.genesys.internal.engagement.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class NotificationPublishParms {
    @SerializedName(value="channel")
    private String channel = null;
    @SerializedName(value="target")
    private String target = null;
    @SerializedName(value="event")
    private String event = null;
    @SerializedName(value="validate_only")
    private Boolean validateOnly = null;

    public NotificationPublishParms channel(String channel) {
        this.channel = channel;
        return this;
    }

    @ApiModelProperty(example="FCM", required=true, value="Channel name. The only accepted value is 'FCM' for now.")
    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public NotificationPublishParms target(String target) {
        this.target = target;
        return this;
    }

    @ApiModelProperty(required=true, value="token identifying the recipient of the message.")
    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public NotificationPublishParms event(String event) {
        this.event = event;
        return this;
    }

    @ApiModelProperty(example="", required=true, value="notification object as documented by Firebase Messaging")
    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public NotificationPublishParms validateOnly(Boolean validateOnly) {
        this.validateOnly = validateOnly;
        return this;
    }

    @ApiModelProperty(value="Enables a dry-run option provided by Firebase. When enabled Firebase validates credentials, recipient, and message structure, but doesn't actually deliver the message.")
    public Boolean isValidateOnly() {
        return this.validateOnly;
    }

    public void setValidateOnly(Boolean validateOnly) {
        this.validateOnly = validateOnly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationPublishParms notificationPublishParms = (NotificationPublishParms)o;
        return Objects.equals(this.channel, notificationPublishParms.channel) && Objects.equals(this.target, notificationPublishParms.target) && Objects.equals(this.event, notificationPublishParms.event) && Objects.equals(this.validateOnly, notificationPublishParms.validateOnly);
    }

    public int hashCode() {
        return Objects.hash(this.channel, this.target, this.event, this.validateOnly);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NotificationPublishParms {\n");
        sb.append("    channel: ").append(this.toIndentedString(this.channel)).append("\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("    event: ").append(this.toIndentedString(this.event)).append("\n");
        sb.append("    validateOnly: ").append(this.toIndentedString(this.validateOnly)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

