/*
 * Decompiled with CFR 0.152.
 */
package com.genesys.internal.engagement.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;

public class QueueStatus {
    @SerializedName(value="ewt")
    private BigDecimal ewt = null;
    @SerializedName(value="offerImmediateCallback")
    private Boolean offerImmediateCallback = null;
    @SerializedName(value="offerScheduledCallback")
    private Boolean offerScheduledCallback = null;

    public QueueStatus ewt(BigDecimal ewt) {
        this.ewt = ewt;
        return this;
    }

    @ApiModelProperty(value="Current estimated wait time in seconds. If ewt is -1 and offerImmediateCallback is true, then that indicates that there has not been any interactions on the queue yet. If ewt is -1 and offerImmediateCallback is false, then that indicates that there are no agents logged to the queue.")
    public BigDecimal getEwt() {
        return this.ewt;
    }

    public void setEwt(BigDecimal ewt) {
        this.ewt = ewt;
    }

    public QueueStatus offerImmediateCallback(Boolean offerImmediateCallback) {
        this.offerImmediateCallback = offerImmediateCallback;
        return this;
    }

    @ApiModelProperty(value="True if the immediateCallbackEnabled setting is true for the queue and if booking an immediate callback at the current time is forecast to be made before the end of the office hours.")
    public Boolean isOfferImmediateCallback() {
        return this.offerImmediateCallback;
    }

    public void setOfferImmediateCallback(Boolean offerImmediateCallback) {
        this.offerImmediateCallback = offerImmediateCallback;
    }

    public QueueStatus offerScheduledCallback(Boolean offerScheduledCallback) {
        this.offerScheduledCallback = offerScheduledCallback;
        return this;
    }

    @ApiModelProperty(value="True if the scheduledCallbackEnabled setting for the queue is true.")
    public Boolean isOfferScheduledCallback() {
        return this.offerScheduledCallback;
    }

    public void setOfferScheduledCallback(Boolean offerScheduledCallback) {
        this.offerScheduledCallback = offerScheduledCallback;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueueStatus queueStatus = (QueueStatus)o;
        return Objects.equals(this.ewt, queueStatus.ewt) && Objects.equals(this.offerImmediateCallback, queueStatus.offerImmediateCallback) && Objects.equals(this.offerScheduledCallback, queueStatus.offerScheduledCallback);
    }

    public int hashCode() {
        return Objects.hash(this.ewt, this.offerImmediateCallback, this.offerScheduledCallback);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QueueStatus {\n");
        sb.append("    ewt: ").append(this.toIndentedString(this.ewt)).append("\n");
        sb.append("    offerImmediateCallback: ").append(this.toIndentedString(this.offerImmediateCallback)).append("\n");
        sb.append("    offerScheduledCallback: ").append(this.toIndentedString(this.offerScheduledCallback)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

