/*
 * Callback and Related APIs
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 3.0.000.19.015
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.genesys.internal.engagement.api;

import com.genesys.internal.common.ApiCallback;
import com.genesys.internal.common.ApiClient;
import com.genesys.internal.common.ApiException;
import com.genesys.internal.common.ApiResponse;
import com.genesys.internal.common.Configuration;
import com.genesys.internal.common.Pair;
import com.genesys.internal.common.ProgressRequestBody;
import com.genesys.internal.common.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.genesys.internal.engagement.model.StatisticsResponse200;
import com.genesys.internal.engagement.model.StatisticsResponse401;
import com.genesys.internal.engagement.model.StatisticsResponse500;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StatisticsApi {
    private ApiClient apiClient;

    public StatisticsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public StatisticsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for statistics
     * @param xApiKey API Key. For example,  Z2y9eiTiQZ4ceKNpxy1YAarhpvxJXPCj4rFrbVep (required)
     * @param cacheControl max-age&#x3D;15 - Acceptable maximum age of cached data specified in seconds. If previous response data (for the same request parameters) is available from the cache and is older than the max-age specified, then a query to GWS statistics is performed. The minimum value that can be specified for max-age is 15. Note that data is cached for 5 minutes. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call statisticsCall(String xApiKey, String cacheControl, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/statistics/operations/get-statistic-ex";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xApiKey != null)
        localVarHeaderParams.put("x-api-key", apiClient.parameterToString(xApiKey));
        if (cacheControl != null)
        localVarHeaderParams.put("cache-control", apiClient.parameterToString(cacheControl));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call statisticsValidateBeforeCall(String xApiKey, String cacheControl, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'xApiKey' is set
        if (xApiKey == null) {
            throw new ApiException("Missing the required parameter 'xApiKey' when calling statistics(Async)");
        }
        

        com.squareup.okhttp.Call call = statisticsCall(xApiKey, cacheControl, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get the values of a set of statistics.
     * Provides a proxy to the GWS statistics API. GWS credentials must be entered in the credentials UI.
     * @param xApiKey API Key. For example,  Z2y9eiTiQZ4ceKNpxy1YAarhpvxJXPCj4rFrbVep (required)
     * @param cacheControl max-age&#x3D;15 - Acceptable maximum age of cached data specified in seconds. If previous response data (for the same request parameters) is available from the cache and is older than the max-age specified, then a query to GWS statistics is performed. The minimum value that can be specified for max-age is 15. Note that data is cached for 5 minutes. (optional)
     * @return StatisticsResponse200
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public StatisticsResponse200 statistics(String xApiKey, String cacheControl) throws ApiException {
        ApiResponse<StatisticsResponse200> resp = statisticsWithHttpInfo(xApiKey, cacheControl);
        return resp.getData();
    }

    /**
     * Get the values of a set of statistics.
     * Provides a proxy to the GWS statistics API. GWS credentials must be entered in the credentials UI.
     * @param xApiKey API Key. For example,  Z2y9eiTiQZ4ceKNpxy1YAarhpvxJXPCj4rFrbVep (required)
     * @param cacheControl max-age&#x3D;15 - Acceptable maximum age of cached data specified in seconds. If previous response data (for the same request parameters) is available from the cache and is older than the max-age specified, then a query to GWS statistics is performed. The minimum value that can be specified for max-age is 15. Note that data is cached for 5 minutes. (optional)
     * @return ApiResponse&lt;StatisticsResponse200&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<StatisticsResponse200> statisticsWithHttpInfo(String xApiKey, String cacheControl) throws ApiException {
        com.squareup.okhttp.Call call = statisticsValidateBeforeCall(xApiKey, cacheControl, null, null);
        Type localVarReturnType = new TypeToken<StatisticsResponse200>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get the values of a set of statistics. (asynchronously)
     * Provides a proxy to the GWS statistics API. GWS credentials must be entered in the credentials UI.
     * @param xApiKey API Key. For example,  Z2y9eiTiQZ4ceKNpxy1YAarhpvxJXPCj4rFrbVep (required)
     * @param cacheControl max-age&#x3D;15 - Acceptable maximum age of cached data specified in seconds. If previous response data (for the same request parameters) is available from the cache and is older than the max-age specified, then a query to GWS statistics is performed. The minimum value that can be specified for max-age is 15. Note that data is cached for 5 minutes. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call statisticsAsync(String xApiKey, String cacheControl, final ApiCallback<StatisticsResponse200> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = statisticsValidateBeforeCall(xApiKey, cacheControl, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<StatisticsResponse200>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
