/*
 * Decompiled with CFR 0.152.
 */
package com.gilt.gfc.aws.kinesis.client;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.dynamodbv2.streamsadapter.AmazonDynamoDBStreamsAdapterClient;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisClientLibConfiguration;
import com.gilt.gfc.aws.kinesis.client.KinesisClientEndpoints;
import java.util.UUID;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.sys.process.package$;

public final class KCLConfiguration$ {
    public static final KCLConfiguration$ MODULE$;
    private final String HostName;

    static {
        new KCLConfiguration$();
    }

    public String HostName() {
        return this.HostName;
    }

    public KinesisClientLibConfiguration apply(String applicationName, String streamName, AWSCredentialsProvider kinesisCredentialsProvider, AWSCredentialsProvider dynamoCredentialsProvider, AWSCredentialsProvider cloudWatchCredentialsProvider, Option<String> regionName, Option<AmazonDynamoDBStreamsAdapterClient> dynamoDBKinesisAdapterClient, InitialPositionInStream initialPositionInStream, Option<KinesisClientEndpoints> endpointConfiguration) {
        String dynamoTableName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{applicationName, streamName})).replaceAll("[^a-zA-Z0-9_.-]", "-");
        KinesisClientLibConfiguration conf = new KinesisClientLibConfiguration(dynamoTableName, streamName, kinesisCredentialsProvider, dynamoCredentialsProvider, cloudWatchCredentialsProvider, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.HostName(), UUID.randomUUID()}))).withRegionName((String)regionName.orNull(Predef$.MODULE$.$conforms())).withInitialPositionInStream(initialPositionInStream);
        KinesisClientLibConfiguration adapterConf = (KinesisClientLibConfiguration)dynamoDBKinesisAdapterClient.map((Function1)new Serializable(conf){
            public static final long serialVersionUID = 0L;
            private final KinesisClientLibConfiguration conf$1;

            public final KinesisClientLibConfiguration apply(AmazonDynamoDBStreamsAdapterClient client) {
                return this.conf$1.withMaxRecords(1000).withIdleTimeBetweenReadsInMillis(500L);
            }
            {
                this.conf$1 = conf$1;
            }
        }).getOrElse((Function0)new Serializable(conf){
            public static final long serialVersionUID = 0L;
            private final KinesisClientLibConfiguration conf$1;

            public final KinesisClientLibConfiguration apply() {
                return this.conf$1;
            }
            {
                this.conf$1 = conf$1;
            }
        });
        return (KinesisClientLibConfiguration)endpointConfiguration.map((Function1)new Serializable(adapterConf){
            public static final long serialVersionUID = 0L;
            private final KinesisClientLibConfiguration adapterConf$1;

            public final KinesisClientLibConfiguration apply(KinesisClientEndpoints endpoints) {
                return this.adapterConf$1.withDynamoDBEndpoint(endpoints.dynamoDBEndpoint()).withKinesisEndpoint(endpoints.kinesisEndpoint());
            }
            {
                this.adapterConf$1 = adapterConf$1;
            }
        }).getOrElse((Function0)new Serializable(adapterConf){
            public static final long serialVersionUID = 0L;
            private final KinesisClientLibConfiguration adapterConf$1;

            public final KinesisClientLibConfiguration apply() {
                return this.adapterConf$1;
            }
            {
                this.adapterConf$1 = adapterConf$1;
            }
        });
    }

    public AWSCredentialsProvider apply$default$3() {
        return new DefaultAWSCredentialsProviderChain();
    }

    public AWSCredentialsProvider apply$default$4() {
        return new DefaultAWSCredentialsProviderChain();
    }

    public AWSCredentialsProvider apply$default$5() {
        return new DefaultAWSCredentialsProviderChain();
    }

    public Option<String> apply$default$6() {
        return None$.MODULE$;
    }

    public Option<AmazonDynamoDBStreamsAdapterClient> apply$default$7() {
        return None$.MODULE$;
    }

    public InitialPositionInStream apply$default$8() {
        return InitialPositionInStream.LATEST;
    }

    public Option<KinesisClientEndpoints> apply$default$9() {
        return None$.MODULE$;
    }

    private KCLConfiguration$() {
        MODULE$ = this;
        this.HostName = package$.MODULE$.stringToProcess("hostname").$bang$bang().trim();
        Predef$.MODULE$.assert(this.HostName() != null, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Couldn't determine hostname, got null";
            }
        });
        Predef$.MODULE$.assert(!this.HostName().isEmpty(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Couldn't determine hostname, got empty string";
            }
        });
    }
}

