package com.gilt.newrelic.logback

import ch.qos.logback.core.AppenderBase
import ch.qos.logback.classic.spi.{ThrowableProxy, ILoggingEvent}
import collection.immutable.HashMap
import com.newrelic.api.agent.NewRelic
import scala.collection.JavaConverters._

/**
 * Logs exceptions to new relic
 */
class Appender extends AppenderBase[ILoggingEvent] {

  override def append(e:ILoggingEvent) {
    var params = new HashMap[String, String]
    params += "message" -> e.getMessage
    params += "loggerName" -> e.getLoggerName
    params += "level" -> e.getLevel.toString
    params += "threadName" -> e.getThreadName

    if(e.getThrowableProxy != null) {
      NewRelic.noticeError(e.getThrowableProxy.asInstanceOf[ThrowableProxy].getThrowable, params.asJava)
    } else {
      NewRelic.noticeError(e.getMessage, params.asJava)
    }
  }
}
