/*
 * Decompiled with CFR 0.152.
 */
package fathom.metrics.influxdb;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import fathom.conf.Settings;
import fathom.metrics.MetricsReporter;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import metrics_influxdb.Influxdb;
import metrics_influxdb.InfluxdbHttp;
import metrics_influxdb.InfluxdbReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reporter
implements MetricsReporter {
    private final Logger log = LoggerFactory.getLogger(Reporter.class);
    private InfluxdbReporter reporter;

    public void start(Settings settings, MetricRegistry metricRegistry) {
        if (settings.getBoolean("metrics.influxdb.enabled", false)) {
            String hostname = settings.getLocalHostname();
            String address = settings.getRequiredString("metrics.influxdb.address");
            int port = settings.getInteger("metrics.influxdb.port", 8086);
            String database = settings.getRequiredString("metrics.influxdb.database");
            String username = settings.getRequiredString("metrics.influxdb.username");
            String password = settings.getRequiredString("metrics.influxdb.password");
            long period = settings.getDuration("metrics.influxdb.period", TimeUnit.SECONDS, 60L);
            try {
                InfluxdbHttp influxdb = new InfluxdbHttp(address, port, database, username, password);
                this.reporter = InfluxdbReporter.forRegistry((MetricRegistry)metricRegistry).prefixedWith(hostname).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(MetricFilter.ALL).build((Influxdb)influxdb);
                this.reporter.start(period, TimeUnit.SECONDS);
                this.log.debug("Started InfluxDB Metrics reporter for '{}', updating every {} seconds", (Object)hostname, (Object)period);
            }
            catch (Exception e) {
                this.log.error("Failed to start InfluxDB reporter!", (Throwable)e);
            }
        } else {
            this.log.debug("InfluxDB Metrics reporter is disabled");
        }
    }

    public void close() throws IOException {
        if (this.reporter != null) {
            this.reporter.stop();
            this.log.debug("Stopped InfluxDB Metrics reporter");
        }
    }
}

