/*
 * Decompiled with CFR 0.152.
 */
package fathom.metrics.librato;

import com.codahale.metrics.MetricRegistry;
import com.librato.metrics.LibratoReporter;
import fathom.conf.Settings;
import fathom.metrics.MetricsReporter;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reporter
implements MetricsReporter {
    private final Logger log = LoggerFactory.getLogger(Reporter.class);

    public void start(Settings settings, MetricRegistry metricRegistry) {
        if (settings.getBoolean("metrics.librato.enabled", false)) {
            String hostname = settings.getLocalHostname();
            String username = settings.getRequiredString("metrics.librato.username");
            String apiKey = settings.getRequiredString("metrics.librato.apikey");
            long period = settings.getDuration("metrics.librato.period", TimeUnit.SECONDS, 60L);
            LibratoReporter.enable((LibratoReporter.Builder)LibratoReporter.builder((MetricRegistry)metricRegistry, (String)username, (String)apiKey, (String)hostname), (long)period, (TimeUnit)TimeUnit.SECONDS);
            this.log.info("Started Librato Metrics reporter for '{}', updating every {} seconds", (Object)hostname, (Object)period);
        } else {
            this.log.debug("Librato Metrics reporter is disabled");
        }
    }

    public void close() throws IOException {
    }
}

