/*
 * Decompiled with CFR 0.152.
 */
package fathom.rest.controller.extractors;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import fathom.realm.Account;
import fathom.rest.Context;
import fathom.rest.controller.Auth;
import fathom.rest.controller.extractors.ConfigurableExtractor;
import fathom.rest.controller.extractors.NamedExtractor;
import fathom.rest.controller.extractors.TypedExtractor;

public class AuthExtractor
implements TypedExtractor,
NamedExtractor,
ConfigurableExtractor<Auth> {
    private String name;

    public Class<Auth> getAnnotationClass() {
        return Auth.class;
    }

    public void configure(Auth param) {
        this.setName(param.value());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setObjectType(Class<?> objectType) {
        Preconditions.checkState((boolean)Account.class.isAssignableFrom(objectType));
    }

    public Account extract(Context context) {
        Account session = (Account)context.getSession("account");
        Account local = (Account)context.getLocal("account");
        Account account = (Account)Optional.fromNullable((Object)session).or(Optional.fromNullable((Object)local).or((Object)Account.GUEST));
        return account;
    }
}

