/*
 * Decompiled with CFR 0.152.
 */
package fathom.rest.security;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import fathom.conf.Settings;
import fathom.realm.Account;
import fathom.rest.Context;
import fathom.rest.security.StandardCredentialsHandler;
import fathom.security.SecurityManager;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import ro.pippo.core.route.RouteHandler;

@Singleton
public final class BasicAuthenticationHandler
extends StandardCredentialsHandler
implements RouteHandler<Context> {
    private final boolean createSessions;
    private final boolean isPassive;
    private final String challenge;

    @Inject
    public BasicAuthenticationHandler(SecurityManager securityManager, Settings settings) {
        this(securityManager, false, false, settings.getApplicationName());
    }

    public BasicAuthenticationHandler(SecurityManager securityManager, boolean createSessions, boolean isPassive, String realmName) {
        super(securityManager);
        this.createSessions = createSessions;
        this.isPassive = isPassive;
        this.challenge = "Basic realm=\"" + realmName + "\"";
    }

    public void handle(Context context) {
        if (this.isAuthenticated(context)) {
            if (this.createSessions) {
                context.touchSession();
            }
            context.next();
            return;
        }
        String authorization = context.getRequest().getHeader("Authorization");
        if (!Strings.isNullOrEmpty((String)authorization) && authorization.startsWith("Basic")) {
            String password;
            String packet = authorization.substring("Basic".length()).trim();
            String credentials = new String(Base64.getDecoder().decode(packet), StandardCharsets.UTF_8);
            String[] values = credentials.split(":", 2);
            String username = values[0];
            Account account = this.authenticate(username, password = values[1]);
            if (account != null) {
                context.setLocal("account", (Object)account);
                if (this.createSessions) {
                    context.setSession("account", (Object)account);
                }
                context.next();
                return;
            }
        }
        if (!this.isPassive) {
            context.setHeader("WWW-Authenticate", (Object)this.challenge);
            context.getResponse().unauthorized();
        }
    }
}

