/*
 * Decompiled with CFR 0.152.
 */
package fathom.rest.security;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import fathom.exception.StatusCodeException;
import fathom.rest.Context;
import fathom.utils.CryptoUtil;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.route.RouteHandler;

@Singleton
public class CSRFHandler
implements RouteHandler<Context> {
    public static final String HEADER = "Csrf-Token";
    public static final String PARAMETER = "_csrf_token";
    public static final String BINDING = "csrfToken";
    private static final Logger log = LoggerFactory.getLogger(CSRFHandler.class);
    private final Set<String> guardedTypes = Sets.newHashSet((Object[])new String[]{"application/x-www-form-urlencoded", "multipart/form-data", "text/plain"});
    private final String secretKey;
    private final String algorithm;

    @Inject
    public CSRFHandler() {
        this(CryptoUtil.generateSecretKey());
    }

    public CSRFHandler(String secretKey) {
        this(secretKey, "HmacSHA256");
    }

    public CSRFHandler(String secretKey, String algorithm) {
        this.secretKey = secretKey;
        this.algorithm = algorithm;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    protected String getSessionCsrfToken(Context context) {
        return (String)context.getSession(PARAMETER);
    }

    protected void setSessionCsrfToken(Context context, String token) {
        context.setSession(PARAMETER, (Object)token);
    }

    protected String getTokenId(Context context) {
        return context.getSession().getId().toString();
    }

    public void handle(Context context) {
        String httpSerlvetRequestMethod = context.getRequest().getHttpServletRequest().getMethod();
        if ("POST".equals(httpSerlvetRequestMethod)) {
            String contentType = context.getRequest().getHeader("Content-Type").toLowerCase();
            if (!this.guardedTypes.contains(contentType)) {
                log.debug("Ignoring '{}' request for {} '{}'", new Object[]{contentType, context.getRequestMethod(), context.getRequestUri()});
                return;
            }
            String requestToken = context.getRequest().getHeader(HEADER);
            if ("nocheck".equals(requestToken)) {
                log.debug("Ignoring 'nocheck' request for {} '{}'", (Object)context.getRequestMethod(), (Object)context.getRequestUri());
                return;
            }
            if (Strings.isNullOrEmpty((String)requestToken)) {
                requestToken = context.getParameter(PARAMETER).toString();
            }
            if (Strings.isNullOrEmpty((String)requestToken)) {
                throw new StatusCodeException(403, "Illegal request, no '{}'!", new Object[]{PARAMETER});
            }
            String sessionToken = this.getSessionCsrfToken(context);
            if (!requestToken.equals(sessionToken)) {
                throw new StatusCodeException(403, "Illegal request, invalid '{}'!", new Object[]{PARAMETER});
            }
            log.debug("Validated '{}' for {} '{}'", new Object[]{PARAMETER, context.getRequestMethod(), context.getRequestUri()});
            context.setLocal(BINDING, (Object)sessionToken);
        } else if ("GET".equals(httpSerlvetRequestMethod)) {
            if (this.getSessionCsrfToken(context) == null) {
                String sessionId = this.getTokenId(context);
                String token = CryptoUtil.hmacDigest((String)sessionId, (String)this.secretKey, (String)this.algorithm);
                this.setSessionCsrfToken(context, token);
                log.debug("Generated '{}' for {} '{}'", new Object[]{PARAMETER, httpSerlvetRequestMethod, context.getRequestUri()});
            }
            String token = this.getSessionCsrfToken(context);
            context.setLocal(BINDING, (Object)token);
        }
        context.next();
    }
}

