/*
 * Decompiled with CFR 0.152.
 */
package fathom.rest.security;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import fathom.conf.Settings;
import fathom.rest.Context;
import ro.pippo.core.route.RouteHandler;

@Singleton
public class FormAuthenticationGuard
implements RouteHandler<Context> {
    protected final String loginPath;

    @Inject
    public FormAuthenticationGuard(Settings settings) {
        this.loginPath = settings.getString("fathom.formLoginPath", "/login");
    }

    public FormAuthenticationGuard(String loginPath) {
        this.loginPath = loginPath;
    }

    public void handle(Context context) {
        if (context.getSession("account") == null) {
            String requestUri = context.getRequest().getApplicationUriWithQuery();
            context.setSession("originalDestination", (Object)requestUri);
            context.redirect(this.loginPath);
        } else {
            context.next();
        }
    }
}

