/*
 * Decompiled with CFR 0.152.
 */
package fathom.rest.security;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import fathom.exception.StatusCodeException;
import fathom.realm.Account;
import fathom.rest.Context;
import fathom.rest.security.StandardCredentialsHandler;
import fathom.security.SecurityManager;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.Cookie;
import ro.pippo.core.Messages;
import ro.pippo.core.route.RouteContext;
import ro.pippo.core.route.RouteHandler;

@Singleton
public final class FormAuthenticationHandler
extends StandardCredentialsHandler
implements RouteHandler<Context> {
    @Inject
    Messages messages;

    @Inject
    public FormAuthenticationHandler(SecurityManager securityManager) {
        super(securityManager);
    }

    public void handle(Context context) {
        if (this.isAuthenticated(context)) {
            context.touchSession();
            this.redirectRequest(context);
            return;
        }
        if ("GET".equals(context.getRequestMethod())) {
            context.render("login");
        } else if ("POST".equals(context.getRequestMethod())) {
            String username = context.getParameter("username").toString();
            String password = context.getParameter("password").toString();
            boolean rememberMe = context.getParameter("rememberMe").toBoolean(false);
            Account account = this.authenticate(username, password);
            if (account != null) {
                context.recreateSession();
                Cookie c = new Cookie("fsession", username);
                c.setHttpOnly(true);
                c.setMaxAge(-1);
                context.getResponse().cookie(c);
                context.setLocal("account", (Object)account);
                context.setSession("account", (Object)account);
                if (rememberMe) {
                    Cookie cookie = new Cookie("RememberMe", username);
                    cookie.setHttpOnly(true);
                    cookie.setMaxAge((int)TimeUnit.DAYS.toSeconds(365L));
                    context.getResponse().cookie(cookie);
                }
                this.redirectRequest(context);
            } else {
                String message = this.messages.getWithDefault("fathom.invalidCredentials", "Invalid Credentials", (RouteContext)context, new Object[0]);
                context.flashError(message, new Object[0]);
                context.redirect(context.getRequestUri());
            }
        } else {
            throw new StatusCodeException(405, "Only GET and POST are supported!", new Object[0]);
        }
    }

    protected void redirectRequest(Context context) {
        String originalDestination = (String)context.getSession("originalDestination");
        String redirectPath = (String)Optional.fromNullable((Object)Strings.emptyToNull((String)originalDestination)).or((Object)"/");
        context.redirect(redirectPath);
    }
}

